/*
 * Decompiled with CFR 0.152.
 */
package feign.error;

import feign.Request;
import feign.Response;
import feign.Types;
import feign.Util;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import feign.error.FeignExceptionConstructor;
import feign.error.ResponseHeaders;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ExceptionGenerator {
    private static final Response TEST_RESPONSE;
    private final Integer bodyIndex;
    private final Integer requestIndex;
    private final Integer headerMapIndex;
    private final Integer numOfParams;
    private final Type bodyType;
    private final Class<? extends Exception> exceptionType;
    private final Decoder bodyDecoder;

    ExceptionGenerator(Integer bodyIndex, Integer requestIndex, Integer headerMapIndex, Integer numOfParams, Type bodyType, Class<? extends Exception> exceptionType, Decoder bodyDecoder) {
        this.bodyIndex = bodyIndex;
        this.requestIndex = requestIndex;
        this.headerMapIndex = headerMapIndex;
        this.numOfParams = numOfParams;
        this.bodyType = bodyType;
        this.exceptionType = exceptionType;
        this.bodyDecoder = bodyDecoder;
    }

    Exception createException(Response response) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Class[] paramClasses = new Class[this.numOfParams.intValue()];
        Object[] paramValues = new Object[this.numOfParams.intValue()];
        if (this.bodyIndex >= 0) {
            paramClasses[this.bodyIndex.intValue()] = Types.getRawType((Type)this.bodyType);
            paramValues[this.bodyIndex.intValue()] = this.resolveBody(response);
        }
        if (this.requestIndex >= 0) {
            paramClasses[this.requestIndex.intValue()] = Request.class;
            paramValues[this.requestIndex.intValue()] = response.request();
        }
        if (this.headerMapIndex >= 0) {
            paramValues[this.headerMapIndex.intValue()] = response.headers();
            paramClasses[this.headerMapIndex.intValue()] = Map.class;
        }
        return this.exceptionType.getConstructor(paramClasses).newInstance(paramValues);
    }

    Class<? extends Exception> getExceptionType() {
        return this.exceptionType;
    }

    private Object resolveBody(Response response) {
        if (this.bodyType instanceof Class && ((Class)this.bodyType).isInstance(response)) {
            return response;
        }
        try {
            return this.bodyDecoder.decode(response, this.bodyType);
        }
        catch (IOException e) {
            return null;
        }
        catch (DecodeException e) {
            return null;
        }
    }

    static {
        HashMap<String, List<String>> testHeaders = new HashMap<String, List<String>>();
        testHeaders.put("TestHeader", Arrays.asList("header-value"));
        TEST_RESPONSE = Response.builder().status(500).body((Response.Body)null).headers(testHeaders).request(Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"http://test", testHeaders, (Request.Body)Request.Body.empty(), null)).build();
    }

    static class Builder {
        private Class<? extends Exception> exceptionType;
        private Decoder responseBodyDecoder;

        Builder() {
        }

        public Builder withExceptionType(Class<? extends Exception> exceptionType) {
            this.exceptionType = exceptionType;
            return this;
        }

        public Builder withResponseBodyDecoder(Decoder bodyDecoder) {
            this.responseBodyDecoder = bodyDecoder;
            return this;
        }

        public ExceptionGenerator build() {
            Constructor<? extends Exception> constructor = this.getConstructor(this.exceptionType);
            Type[] parameterTypes = constructor.getGenericParameterTypes();
            Annotation[][] parametersAnnotations = constructor.getParameterAnnotations();
            Integer bodyIndex = -1;
            Integer requestIndex = -1;
            Integer headerMapIndex = -1;
            Integer numOfParams = parameterTypes.length;
            Type bodyType = null;
            for (int i = 0; i < parameterTypes.length; ++i) {
                Annotation[] paramAnnotations = parametersAnnotations[i];
                boolean foundAnnotation = false;
                for (Annotation annotation : paramAnnotations) {
                    if (!annotation.annotationType().equals(ResponseHeaders.class)) continue;
                    Util.checkState((headerMapIndex == -1 ? 1 : 0) != 0, (String)"Cannot have two parameters tagged with @ResponseHeaders", (Object[])new Object[0]);
                    Util.checkState((boolean)Types.getRawType((Type)parameterTypes[i]).equals(Map.class), (String)"Response Header map must be of type Map, but was %s", (Object[])new Object[]{parameterTypes[i]});
                    headerMapIndex = i;
                    foundAnnotation = true;
                    break;
                }
                if (foundAnnotation) continue;
                if (parameterTypes[i].equals(Request.class)) {
                    Util.checkState((requestIndex == -1 ? 1 : 0) != 0, (String)"Cannot have two parameters either without annotations or with object of type feign.Request", (Object[])new Object[0]);
                    requestIndex = i;
                    continue;
                }
                Util.checkState((bodyIndex == -1 ? 1 : 0) != 0, (String)"Cannot have two parameters either without annotations or with @ResponseBody annotation", (Object[])new Object[0]);
                bodyIndex = i;
                bodyType = parameterTypes[i];
            }
            ExceptionGenerator generator = new ExceptionGenerator(bodyIndex, requestIndex, headerMapIndex, numOfParams, bodyType, this.exceptionType, this.responseBodyDecoder);
            this.validateGeneratorCanBeUsedToGenerateExceptions(generator);
            return generator;
        }

        private void validateGeneratorCanBeUsedToGenerateExceptions(ExceptionGenerator generator) {
            try {
                generator.createException(TEST_RESPONSE);
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot generate exception - check constructor parameter types (are headers Map<String,Collection<String>> or is something causing an exception on construction?)", e);
            }
        }

        private Constructor<? extends Exception> getConstructor(Class<? extends Exception> exceptionClass) {
            Constructor<?> preferredConstructor = null;
            for (Constructor<?> constructor : exceptionClass.getConstructors()) {
                Class<?>[] parameterTypes;
                FeignExceptionConstructor exceptionConstructor = constructor.getAnnotation(FeignExceptionConstructor.class);
                if (exceptionConstructor == null || (parameterTypes = constructor.getParameterTypes()).length == 0) continue;
                if (preferredConstructor == null) {
                    preferredConstructor = constructor;
                    continue;
                }
                throw new IllegalStateException("Too many constructors marked with @FeignExceptionConstructor");
            }
            if (preferredConstructor == null) {
                try {
                    return exceptionClass.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("Cannot find any suitable constructor in class [" + exceptionClass.getName() + "] - did you forget to mark one with @FeignExceptionConstructor or at least have a public default constructor?", e);
                }
            }
            return preferredConstructor;
        }
    }
}

