/*
 * Decompiled with CFR 0.152.
 */
package io.github.oshai.kotlinlogging;

import io.github.oshai.kotlinlogging.Appender;
import io.github.oshai.kotlinlogging.DefaultAppenderKt;
import io.github.oshai.kotlinlogging.DefaultMessageFormatter;
import io.github.oshai.kotlinlogging.DirectLoggerFactory;
import io.github.oshai.kotlinlogging.Formatter;
import io.github.oshai.kotlinlogging.KLoggerFactory;
import io.github.oshai.kotlinlogging.Level;
import io.github.oshai.kotlinlogging.jul.internal.JulLoggerFactory;
import io.github.oshai.kotlinlogging.logback.internal.LogbackLoggerFactory;
import io.github.oshai.kotlinlogging.slf4j.internal.Slf4jLoggerFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u0005H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lio/github/oshai/kotlinlogging/KotlinLoggingConfiguration;", "", "<init>", "()V", "loggerFactory", "Lio/github/oshai/kotlinlogging/KLoggerFactory;", "getLoggerFactory", "()Lio/github/oshai/kotlinlogging/KLoggerFactory;", "setLoggerFactory", "(Lio/github/oshai/kotlinlogging/KLoggerFactory;)V", "direct", "Lio/github/oshai/kotlinlogging/KotlinLoggingConfiguration$DirectLoggingConfiguration;", "getDirect", "()Lio/github/oshai/kotlinlogging/KotlinLoggingConfiguration$DirectLoggingConfiguration;", "detectLogger", "DirectLoggingConfiguration", "kotlin-logging"})
public final class KotlinLoggingConfiguration {
    @NotNull
    public static final KotlinLoggingConfiguration INSTANCE = new KotlinLoggingConfiguration();
    @NotNull
    private static volatile KLoggerFactory loggerFactory = INSTANCE.detectLogger();
    @NotNull
    private static final DirectLoggingConfiguration direct = new DirectLoggingConfiguration(){
        private volatile Level logLevel;
        private volatile Formatter formatter;
        private volatile Appender appender;
        {
            this.logLevel = Level.INFO;
            this.formatter = new DefaultMessageFormatter(true);
            this.appender = DefaultAppenderKt.getDefaultAppender();
        }

        public Level getLogLevel() {
            return this.logLevel;
        }

        public void setLogLevel(Level value) {
            Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
            this.logLevel = value;
            this.checkFactory("logLevel");
        }

        public Formatter getFormatter() {
            return this.formatter;
        }

        public void setFormatter(Formatter value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.formatter = value;
            this.checkFactory("formatter");
        }

        public Appender getAppender() {
            return this.appender;
        }

        public void setAppender(Appender value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.appender = value;
            this.checkFactory("appender");
        }

        private final void checkFactory(String name) {
            if (!Intrinsics.areEqual((Object)KotlinLoggingConfiguration.INSTANCE.getLoggerFactory(), (Object)DirectLoggerFactory.INSTANCE)) {
                String string = "kotlin-logging: [WARN] configuring 'direct." + name + "' but the active logger factory is not 'DirectLoggerFactory' (active: " + Reflection.getOrCreateKotlinClass(KotlinLoggingConfiguration.INSTANCE.getLoggerFactory().getClass()).getSimpleName() + "). This config might be ignored.";
                System.out.println((Object)string);
            }
        }
    };

    private KotlinLoggingConfiguration() {
    }

    @NotNull
    public final KLoggerFactory getLoggerFactory() {
        return loggerFactory;
    }

    public final void setLoggerFactory(@NotNull KLoggerFactory kLoggerFactory) {
        Intrinsics.checkNotNullParameter((Object)kLoggerFactory, (String)"<set-?>");
        loggerFactory = kLoggerFactory;
    }

    @NotNull
    public final DirectLoggingConfiguration getDirect() {
        return direct;
    }

    private final KLoggerFactory detectLogger() {
        if (System.getProperty("kotlin-logging-to-jul") != null) {
            return JulLoggerFactory.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)System.getProperty("kotlin-logging-to-logback"), (Object)"true")) {
            return LogbackLoggerFactory.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)System.getProperty("kotlin-logging-to-direct"), (Object)"true")) {
            return DirectLoggerFactory.INSTANCE;
        }
        return Slf4jLoggerFactory.INSTANCE;
    }

    static {
        String string = "kotlin-logging: initializing... active logger factory: " + Reflection.getOrCreateKotlinClass(loggerFactory.getClass()).getSimpleName();
        System.out.println((Object)string);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\tX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\u00020\u000fX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lio/github/oshai/kotlinlogging/KotlinLoggingConfiguration$DirectLoggingConfiguration;", "", "logLevel", "Lio/github/oshai/kotlinlogging/Level;", "getLogLevel", "()Lio/github/oshai/kotlinlogging/Level;", "setLogLevel", "(Lio/github/oshai/kotlinlogging/Level;)V", "formatter", "Lio/github/oshai/kotlinlogging/Formatter;", "getFormatter", "()Lio/github/oshai/kotlinlogging/Formatter;", "setFormatter", "(Lio/github/oshai/kotlinlogging/Formatter;)V", "appender", "Lio/github/oshai/kotlinlogging/Appender;", "getAppender", "()Lio/github/oshai/kotlinlogging/Appender;", "setAppender", "(Lio/github/oshai/kotlinlogging/Appender;)V", "kotlin-logging"})
    public static interface DirectLoggingConfiguration {
        @NotNull
        public Level getLogLevel();

        public void setLogLevel(@NotNull Level var1);

        @NotNull
        public Formatter getFormatter();

        public void setFormatter(@NotNull Formatter var1);

        @NotNull
        public Appender getAppender();

        public void setAppender(@NotNull Appender var1);
    }
}

