/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.version;

import org.jetbrains.annotations.NotNull;

public final class Version {
    private final int major;
    private final int minor;

    @NotNull
    public static Version from(@NotNull String versionString) {
        if (!versionString.contains(".")) {
            throw new UnsupportedOperationException("Make sure the string that you want to convert as a 'Version' class have '.' between version numbers!");
        }
        String[] split = versionString.split("\\.");
        if (split.length != 2) {
            throw new UnsupportedOperationException("Make sure pattern from the string that you want to convert as a 'Version' class is like '<any-number>.<any-number>'");
        }
        try {
            return new Version(Integer.parseInt(split[0]), Integer.parseInt(split[1]));
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Make sure pattern from the string that you want to convert as a 'Version' class is like '<any-number>.<any-number>'");
        }
    }

    public boolean afterThan(@NotNull Version version) {
        return this.major > version.major || this.major == version.major && this.minor > version.minor;
    }

    public boolean beforeThan(@NotNull Version version) {
        return this.major < version.major || this.major == version.major && this.minor < version.minor;
    }

    public boolean is(@NotNull Version version) {
        return this.minor == version.minor && this.major == version.major;
    }

    public Version(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }
}

