/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.internal;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.RegistryStore;
import io.github.resilience4j.core.registry.AbstractRegistry;
import io.github.resilience4j.core.registry.InMemoryRegistryStore;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public final class InMemoryCircuitBreakerRegistry
extends AbstractRegistry<CircuitBreaker, CircuitBreakerConfig>
implements CircuitBreakerRegistry {
    public InMemoryCircuitBreakerRegistry() {
        this(Collections.emptyMap());
    }

    public InMemoryCircuitBreakerRegistry(Map<String, CircuitBreakerConfig> configs) {
        this(configs, Collections.emptyMap());
    }

    public InMemoryCircuitBreakerRegistry(Map<String, CircuitBreakerConfig> configs, Map<String, String> tags) {
        this(configs.getOrDefault("default", CircuitBreakerConfig.ofDefaults()), tags);
        this.configurations.putAll(configs);
    }

    public InMemoryCircuitBreakerRegistry(Map<String, CircuitBreakerConfig> configs, RegistryEventConsumer<CircuitBreaker> registryEventConsumer) {
        this(configs.getOrDefault("default", CircuitBreakerConfig.ofDefaults()), registryEventConsumer);
        this.configurations.putAll(configs);
    }

    public InMemoryCircuitBreakerRegistry(Map<String, CircuitBreakerConfig> configs, RegistryEventConsumer<CircuitBreaker> registryEventConsumer, Map<String, String> tags) {
        this(configs.getOrDefault("default", CircuitBreakerConfig.ofDefaults()), registryEventConsumer, tags);
        this.configurations.putAll(configs);
    }

    public InMemoryCircuitBreakerRegistry(Map<String, CircuitBreakerConfig> configs, List<RegistryEventConsumer<CircuitBreaker>> registryEventConsumers, Map<String, String> tags, RegistryStore<CircuitBreaker> registryStore) {
        super((Object)configs.getOrDefault("default", CircuitBreakerConfig.ofDefaults()), registryEventConsumers, Optional.ofNullable(tags).orElse(Collections.emptyMap()), Optional.ofNullable(registryStore).orElse((RegistryStore<CircuitBreaker>)new InMemoryRegistryStore()));
        this.configurations.putAll(configs);
    }

    public InMemoryCircuitBreakerRegistry(Map<String, CircuitBreakerConfig> configs, List<RegistryEventConsumer<CircuitBreaker>> registryEventConsumers) {
        this(configs.getOrDefault("default", CircuitBreakerConfig.ofDefaults()), registryEventConsumers);
        this.configurations.putAll(configs);
    }

    public InMemoryCircuitBreakerRegistry(CircuitBreakerConfig defaultConfig) {
        super((Object)defaultConfig);
    }

    public InMemoryCircuitBreakerRegistry(CircuitBreakerConfig defaultConfig, Map<String, String> tags) {
        super((Object)defaultConfig, tags);
    }

    public InMemoryCircuitBreakerRegistry(CircuitBreakerConfig defaultConfig, RegistryEventConsumer<CircuitBreaker> registryEventConsumer) {
        super((Object)defaultConfig, registryEventConsumer);
    }

    public InMemoryCircuitBreakerRegistry(CircuitBreakerConfig defaultConfig, RegistryEventConsumer<CircuitBreaker> registryEventConsumer, Map<String, String> tags) {
        super((Object)defaultConfig, registryEventConsumer, tags);
    }

    public InMemoryCircuitBreakerRegistry(CircuitBreakerConfig defaultConfig, List<RegistryEventConsumer<CircuitBreaker>> registryEventConsumers) {
        super((Object)defaultConfig, registryEventConsumers);
    }

    @Override
    public Set<CircuitBreaker> getAllCircuitBreakers() {
        return new HashSet<CircuitBreaker>(this.entryMap.values());
    }

    @Override
    public CircuitBreaker circuitBreaker(String name) {
        return this.circuitBreaker(name, (CircuitBreakerConfig)this.getDefaultConfig());
    }

    @Override
    public CircuitBreaker circuitBreaker(String name, Map<String, String> tags) {
        return this.circuitBreaker(name, (CircuitBreakerConfig)this.getDefaultConfig(), tags);
    }

    @Override
    public CircuitBreaker circuitBreaker(String name, CircuitBreakerConfig config) {
        return this.circuitBreaker(name, config, Collections.emptyMap());
    }

    @Override
    public CircuitBreaker circuitBreaker(String name, CircuitBreakerConfig config, Map<String, String> tags) {
        return (CircuitBreaker)this.computeIfAbsent(name, () -> CircuitBreaker.of(name, Objects.requireNonNull(config, "Config must not be null"), (Map<String, String>)this.getAllTags(tags)));
    }

    @Override
    public CircuitBreaker circuitBreaker(String name, String configName) {
        return this.circuitBreaker(name, configName, Collections.emptyMap());
    }

    @Override
    public CircuitBreaker circuitBreaker(String name, String configName, Map<String, String> tags) {
        return (CircuitBreaker)this.computeIfAbsent(name, () -> CircuitBreaker.of(name, (CircuitBreakerConfig)this.getConfiguration(configName).orElseThrow(() -> new ConfigurationNotFoundException(configName)), (Map<String, String>)this.getAllTags(tags)));
    }

    @Override
    public CircuitBreaker circuitBreaker(String name, Supplier<CircuitBreakerConfig> circuitBreakerConfigSupplier) {
        return this.circuitBreaker(name, circuitBreakerConfigSupplier, Collections.emptyMap());
    }

    @Override
    public CircuitBreaker circuitBreaker(String name, Supplier<CircuitBreakerConfig> circuitBreakerConfigSupplier, Map<String, String> tags) {
        return (CircuitBreaker)this.computeIfAbsent(name, () -> CircuitBreaker.of(name, Objects.requireNonNull((CircuitBreakerConfig)Objects.requireNonNull(circuitBreakerConfigSupplier, "Supplier must not be null").get(), "Config must not be null"), (Map<String, String>)this.getAllTags(tags)));
    }
}

