/*
 * Decompiled with CFR 0.152.
 */
package io.github.sercasti.tracing.filter;

import io.github.sercasti.tracing.core.Metric;
import io.github.sercasti.tracing.core.Tracing;
import io.github.sercasti.tracing.core.TracingImpl;
import io.github.sercasti.tracing.domain.HttpServletResponseCopier;
import java.io.IOException;
import java.time.Duration;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
@Order(value=1)
public class TracingFilter
extends OncePerRequestFilter {
    static final ThreadLocal<TracingImpl> tracingLocal = new ThreadLocal();
    @Value(value="${tracing.disabled}")
    private final boolean disabled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String chainingHeaders = request.getHeader("Server-Timing");
        HttpServletResponseCopier responseWrapper = new HttpServletResponseCopier(response);
        TracingImpl tracing = new TracingImpl();
        tracingLocal.set(tracing);
        try {
            Metric totalMetric = tracing.start("total", "total duration of the request");
            filterChain.doFilter((ServletRequest)request, (ServletResponse)responseWrapper);
            totalMetric.stop();
        }
        finally {
            responseWrapper.flushBuffer();
            tracing.dump(response, chainingHeaders);
            tracingLocal.set(null);
            responseWrapper.reallyFlush();
        }
    }

    public static Tracing getCurrentTiming() {
        TracingImpl timing = tracingLocal.get();
        if (timing == null) {
            return new Tracing(){

                @Override
                public Metric start(final String name, final String description) {
                    return new Metric(name, description){

                        @Override
                        public String getName() {
                            return name;
                        }

                        @Override
                        public String getDescription() {
                            return description;
                        }

                        @Override
                        public Duration getDuration() {
                            return null;
                        }

                        @Override
                        public void stop() throws IllegalStateException {
                        }
                    };
                }
            };
        }
        return timing;
    }
}

