/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.asyncapi.v3.model.channel.message;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.github.springwolf.asyncapi.v3.model.Reference;
import io.github.springwolf.asyncapi.v3.model.channel.message.Message;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageObject;

public class MessageReference
implements Message,
Reference {
    @JsonIgnore
    private String ref;

    @Override
    public String getRef() {
        return this.ref;
    }

    public static MessageReference toComponentMessage(MessageObject message) {
        return MessageReference.toComponentMessage(message.getName());
    }

    public static MessageReference toComponentMessage(String messageName) {
        return new MessageReference("#/components/messages/" + messageName);
    }

    public static MessageReference toChannelMessage(String channelName, MessageObject message) {
        return new MessageReference("#/channels/" + channelName + "/messages/" + message.getName());
    }

    public static MessageReference toChannelMessage(String channelName, String messageName) {
        return new MessageReference("#/channels/" + channelName + "/messages/" + messageName);
    }

    public static MessageReference toSchema(String schemaName) {
        return new MessageReference("#/components/schemas/" + schemaName);
    }

    public static String extractRefName(String ref) {
        if (ref.contains("/")) {
            return ref.substring(ref.lastIndexOf(47) + 1);
        }
        return ref;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageReference)) {
            return false;
        }
        MessageReference other = (MessageReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$ref = this.getRef();
        String other$ref = other.getRef();
        return !(this$ref == null ? other$ref != null : !this$ref.equals(other$ref));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageReference;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $ref = this.getRef();
        result = result * 59 + ($ref == null ? 43 : $ref.hashCode());
        return result;
    }

    public MessageReference() {
    }

    public MessageReference(String ref) {
        this.ref = ref;
    }
}

