/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf;

import io.github.stavshamir.springwolf.SpringwolfScannerConfiguration;
import io.github.stavshamir.springwolf.SpringwolfWebConfiguration;
import io.github.stavshamir.springwolf.asyncapi.AsyncApiCustomizer;
import io.github.stavshamir.springwolf.asyncapi.AsyncApiService;
import io.github.stavshamir.springwolf.asyncapi.ChannelsService;
import io.github.stavshamir.springwolf.asyncapi.DefaultAsyncApiService;
import io.github.stavshamir.springwolf.asyncapi.DefaultChannelsService;
import io.github.stavshamir.springwolf.asyncapi.SpringwolfInitApplicationListener;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.ChannelsScanner;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.payload.PayloadClassExtractor;
import io.github.stavshamir.springwolf.configuration.AsyncApiDocket;
import io.github.stavshamir.springwolf.configuration.AsyncApiDocketService;
import io.github.stavshamir.springwolf.configuration.DefaultAsyncApiDocketService;
import io.github.stavshamir.springwolf.configuration.properties.SpringwolfConfigProperties;
import io.github.stavshamir.springwolf.schemas.DefaultSchemasService;
import io.github.stavshamir.springwolf.schemas.SchemasService;
import io.github.stavshamir.springwolf.schemas.example.ExampleGenerator;
import io.github.stavshamir.springwolf.schemas.example.ExampleJsonGenerator;
import io.github.stavshamir.springwolf.schemas.postprocessor.AvroSchemaPostProcessor;
import io.github.stavshamir.springwolf.schemas.postprocessor.ExampleGeneratorPostProcessor;
import io.github.stavshamir.springwolf.schemas.postprocessor.SchemasPostProcessor;
import io.github.stavshamir.springwolf.schemas.postprocessor.SwaggerSchemaPostProcessor;
import io.swagger.v3.core.converter.ModelConverter;
import java.util.List;
import java.util.Optional;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;

@AutoConfiguration
@Import(value={SpringwolfWebConfiguration.class, SpringwolfScannerConfiguration.class})
@ConditionalOnProperty(name={"springwolf.enabled"}, havingValue="true", matchIfMissing=true)
public class SpringwolfAutoConfiguration {
    @Bean
    public SpringwolfConfigProperties springwolfConfigProperties() {
        return new SpringwolfConfigProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringwolfInitApplicationListener springwolfInitApplicationListener(AsyncApiService asyncApiService, SpringwolfConfigProperties configProperties) {
        return new SpringwolfInitApplicationListener(asyncApiService, configProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public AsyncApiService asyncApiService(AsyncApiDocketService asyncApiDocketService, ChannelsService channelsService, SchemasService schemasService, List<AsyncApiCustomizer> customizers) {
        return new DefaultAsyncApiService(asyncApiDocketService, channelsService, schemasService, customizers);
    }

    @Bean
    @ConditionalOnMissingBean
    public ChannelsService channelsService(List<? extends ChannelsScanner> channelsScanners) {
        return new DefaultChannelsService(channelsScanners);
    }

    @Bean
    @ConditionalOnMissingBean
    public SchemasService schemasService(List<ModelConverter> modelConverters, List<SchemasPostProcessor> schemaPostProcessors, SpringwolfConfigProperties springwolfConfigProperties) {
        return new DefaultSchemasService(modelConverters, schemaPostProcessors, springwolfConfigProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public AsyncApiDocketService asyncApiDocketService(Optional<AsyncApiDocket> optionalAsyncApiDocket, SpringwolfConfigProperties springwolfConfigProperties) {
        return new DefaultAsyncApiDocketService(optionalAsyncApiDocket, springwolfConfigProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    @Order(value=0)
    public AvroSchemaPostProcessor avroSchemaPostProcessor() {
        return new AvroSchemaPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    @Order(value=10)
    public ExampleGeneratorPostProcessor exampleGeneratorPostProcessor(ExampleGenerator exampleGenerator) {
        return new ExampleGeneratorPostProcessor(exampleGenerator);
    }

    @Bean
    @ConditionalOnMissingBean
    @Order(value=100)
    public SwaggerSchemaPostProcessor swaggerSchemaPostProcessor() {
        return new SwaggerSchemaPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    public ExampleGenerator exampleGenerator() {
        return new ExampleJsonGenerator();
    }

    @Bean
    @ConditionalOnMissingBean
    public PayloadClassExtractor payloadClassExtractor(SpringwolfConfigProperties springwolfConfigProperties) {
        return new PayloadClassExtractor(springwolfConfigProperties);
    }
}

