/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi;

import com.asyncapi.v2._6_0.model.channel.ChannelItem;
import io.github.stavshamir.springwolf.asyncapi.AsyncApiCustomizer;
import io.github.stavshamir.springwolf.asyncapi.AsyncApiService;
import io.github.stavshamir.springwolf.asyncapi.ChannelsService;
import io.github.stavshamir.springwolf.asyncapi.types.AsyncAPI;
import io.github.stavshamir.springwolf.asyncapi.types.Components;
import io.github.stavshamir.springwolf.configuration.AsyncApiDocket;
import io.github.stavshamir.springwolf.configuration.AsyncApiDocketService;
import io.github.stavshamir.springwolf.schemas.SchemasService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsyncApiService
implements AsyncApiService {
    private static final Logger log = LoggerFactory.getLogger(DefaultAsyncApiService.class);
    private final AsyncApiDocketService asyncApiDocketService;
    private final ChannelsService channelsService;
    private final SchemasService schemasService;
    private final List<AsyncApiCustomizer> customizers;
    private volatile AsyncAPIResult asyncAPIResult = null;

    @Override
    public AsyncAPI getAsyncAPI() {
        if (this.isNotInitialized()) {
            this.initAsyncAPI();
        }
        if (this.asyncAPIResult.asyncAPI != null) {
            return this.asyncAPIResult.asyncAPI;
        }
        throw new RuntimeException("Error occured during creation of AsyncAPI", this.asyncAPIResult.exception);
    }

    protected synchronized void initAsyncAPI() {
        if (this.asyncAPIResult != null) {
            return;
        }
        try {
            log.debug("Building AsyncAPI document");
            AsyncApiDocket docket = this.asyncApiDocketService.getAsyncApiDocket();
            Map<String, ChannelItem> channels = this.channelsService.findChannels();
            Components components = Components.builder().schemas(this.schemasService.getDefinitions()).build();
            AsyncAPI asyncAPI = AsyncAPI.builder().info(docket.getInfo()).id(docket.getId()).defaultContentType(docket.getDefaultContentType()).servers(docket.getServers()).channels(channels).components(components).build();
            for (AsyncApiCustomizer customizer : this.customizers) {
                log.debug("Starting customizer %s".formatted(customizer.getClass().getName()));
                customizer.customize(asyncAPI);
            }
            this.asyncAPIResult = new AsyncAPIResult(asyncAPI, null);
            log.debug("AsyncAPI document was build");
        }
        catch (Throwable t) {
            log.debug("Failed to build AsyncAPI document", t);
            this.asyncAPIResult = new AsyncAPIResult(null, t);
        }
    }

    public boolean isNotInitialized() {
        return this.asyncAPIResult == null;
    }

    public DefaultAsyncApiService(AsyncApiDocketService asyncApiDocketService, ChannelsService channelsService, SchemasService schemasService, List<AsyncApiCustomizer> customizers) {
        this.asyncApiDocketService = asyncApiDocketService;
        this.channelsService = channelsService;
        this.schemasService = schemasService;
        this.customizers = customizers;
    }

    private record AsyncAPIResult(AsyncAPI asyncAPI, Throwable exception) {
    }
}

