/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi;

import com.asyncapi.v2._6_0.model.channel.ChannelItem;
import io.github.stavshamir.springwolf.asyncapi.ChannelsService;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.ChannelMerger;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.ChannelsScanner;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChannelsService
implements ChannelsService {
    private static final Logger log = LoggerFactory.getLogger(DefaultChannelsService.class);
    private final List<? extends ChannelsScanner> channelsScanners;

    @Override
    public Map<String, ChannelItem> findChannels() {
        ArrayList<Map.Entry<String, ChannelItem>> foundChannelItems = new ArrayList<Map.Entry<String, ChannelItem>>();
        for (ChannelsScanner channelsScanner : this.channelsScanners) {
            try {
                Map<String, ChannelItem> channels = channelsScanner.scan();
                foundChannelItems.addAll(channels.entrySet());
            }
            catch (Exception e) {
                log.error("An error was encountered during channel scanning with {}: {}", new Object[]{channelsScanner, e.getMessage(), e});
            }
        }
        return ChannelMerger.merge(foundChannelItems);
    }

    public DefaultChannelsService(List<? extends ChannelsScanner> channelsScanners) {
        this.channelsScanners = channelsScanners;
    }
}

