/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi;

import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHelper {
    private static final Logger log = LoggerFactory.getLogger(MessageHelper.class);
    private static final String ONE_OF = "oneOf";
    private static final Comparator<Message> byMessageName = Comparator.comparing(Message::getName);
    private static final Supplier<Set<Message>> messageSupplier = () -> new TreeSet<Message>(byMessageName);

    public static Object toMessageObjectOrComposition(Set<Message> messages) {
        return switch (messages.size()) {
            case 0 -> throw new IllegalArgumentException("messages must not be empty");
            case 1 -> messages.toArray()[0];
            default -> Map.of(ONE_OF, new ArrayList(messages.stream().collect(Collectors.toCollection(messageSupplier))));
        };
    }

    public static Set<Message> messageObjectToSet(Object messageObject) {
        if (messageObject instanceof Message) {
            Message message = (Message)messageObject;
            return new HashSet<Message>(Collections.singletonList(message));
        }
        if (messageObject instanceof Map) {
            List messages = (List)((Map)messageObject).get(ONE_OF);
            return new HashSet<Message>(messages);
        }
        log.warn("Message object must contain either a Message or a Map<String, Set<Message>, but contained: {}", messageObject.getClass());
        return new HashSet<Message>();
    }
}

