/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi;

import io.github.stavshamir.springwolf.asyncapi.AsyncApiService;
import io.github.stavshamir.springwolf.configuration.properties.SpringwolfConfigProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

public class SpringwolfInitApplicationListener
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(SpringwolfInitApplicationListener.class);
    private final AsyncApiService asyncApiService;
    private final SpringwolfConfigProperties configProperties;

    public void onApplicationEvent(ApplicationReadyEvent event) {
        if (this.configProperties.getInitMode() == SpringwolfConfigProperties.InitMode.BACKGROUND) {
            log.debug("triggering background asyncapi creation..");
            new Thread(this.asyncApiService::getAsyncAPI).start();
        } else {
            log.debug("triggering asyncapi creation..");
            this.asyncApiService.getAsyncAPI();
        }
    }

    public SpringwolfInitApplicationListener(AsyncApiService asyncApiService, SpringwolfConfigProperties configProperties) {
        this.asyncApiService = asyncApiService;
        this.configProperties = configProperties;
    }
}

