/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.github.stavshamir.springwolf.asyncapi.AsyncApiSerializerService;
import io.github.stavshamir.springwolf.asyncapi.AsyncApiService;
import io.github.stavshamir.springwolf.asyncapi.types.AsyncAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.web.bind.annotation.GetMapping;

@RestControllerEndpoint(id="springwolf")
public class ActuatorAsyncApiController {
    private static final Logger log = LoggerFactory.getLogger(ActuatorAsyncApiController.class);
    private final AsyncApiService asyncApiService;
    private final AsyncApiSerializerService serializer;

    @GetMapping(path={"/docs", "/docs.json"}, produces={"application/json"})
    public String asyncApiJson() throws JsonProcessingException {
        AsyncAPI asyncAPI = this.asyncApiService.getAsyncAPI();
        return this.serializer.toJsonString(asyncAPI);
    }

    @GetMapping(path={"/docs.yaml"}, produces={"application/yaml"})
    public String asyncApiYaml() throws JsonProcessingException {
        AsyncAPI asyncAPI = this.asyncApiService.getAsyncAPI();
        return this.serializer.toYaml(asyncAPI);
    }

    public ActuatorAsyncApiController(AsyncApiService asyncApiService, AsyncApiSerializerService serializer) {
        this.asyncApiService = asyncApiService;
        this.serializer = serializer;
    }
}

