/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.github.stavshamir.springwolf.asyncapi.AsyncApiSerializerService;
import io.github.stavshamir.springwolf.asyncapi.AsyncApiService;
import io.github.stavshamir.springwolf.asyncapi.types.AsyncAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AsyncApiController {
    private static final Logger log = LoggerFactory.getLogger(AsyncApiController.class);
    private final AsyncApiService asyncApiService;
    private final AsyncApiSerializerService serializer;

    @GetMapping(path={"${springwolf.paths.docs:/springwolf/docs}", "${springwolf.paths.docs:/springwolf/docs}.json"}, produces={"application/json"})
    public String asyncApiJson() throws JsonProcessingException {
        log.debug("Returning AsyncApi.json document");
        AsyncAPI asyncAPI = this.asyncApiService.getAsyncAPI();
        return this.serializer.toJsonString(asyncAPI);
    }

    @GetMapping(path={"${springwolf.paths.docs:/springwolf/docs}.yaml"}, produces={"application/yaml"})
    public String asyncApiYaml() throws JsonProcessingException {
        log.debug("Returning AsyncApi.yaml document");
        AsyncAPI asyncAPI = this.asyncApiService.getAsyncAPI();
        return this.serializer.toYaml(asyncAPI);
    }

    public AsyncApiController(AsyncApiService asyncApiService, AsyncApiSerializerService serializer) {
        this.asyncApiService = asyncApiService;
        this.serializer = serializer;
    }
}

