/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.stavshamir.springwolf.asyncapi.controller.dtos.MessageDto;
import io.github.stavshamir.springwolf.schemas.SchemasService;
import io.swagger.v3.oas.models.media.Schema;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishingPayloadCreator {
    private static final Logger log = LoggerFactory.getLogger(PublishingPayloadCreator.class);
    private final SchemasService schemasService;
    private final ObjectMapper objectMapper;

    public Result createPayloadObject(MessageDto message) {
        String messagePayloadType = message.getPayloadType();
        List<String> knownSchemaNames = this.schemasService.getDefinitions().values().stream().map(Schema::getName).toList();
        for (String schemaPayloadType : knownSchemaNames) {
            if (schemaPayloadType == null || !schemaPayloadType.equals(messagePayloadType)) continue;
            try {
                Class<?> payloadClass = Class.forName(schemaPayloadType);
                Object payload = this.objectMapper.readValue(message.getPayload(), payloadClass);
                return new Result(payload, null);
            }
            catch (JsonProcessingException | ClassNotFoundException ex) {
                String errorMessage = MessageFormat.format("Unable to create payload {0} from data: {1}", schemaPayloadType, message.getPayload());
                log.info(errorMessage, ex);
                return new Result(null, errorMessage);
            }
        }
        String errorMessage = MessageFormat.format("Specified payloadType {0} is not a registered springwolf schema.", messagePayloadType);
        String knownPayloadsMessage = MessageFormat.format(" Known payloadTypes: [{0}]", StringUtils.join(knownSchemaNames, (String)", "));
        log.info(errorMessage + knownPayloadsMessage);
        return new Result(null, errorMessage);
    }

    public PublishingPayloadCreator(SchemasService schemasService, ObjectMapper objectMapper) {
        this.schemasService = schemasService;
        this.objectMapper = objectMapper;
    }

    public record Result(Object payload, String errorMessage) {
    }
}

