/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.scanners.channels.annotation;

import com.asyncapi.v2._6_0.model.channel.ChannelItem;
import com.asyncapi.v2._6_0.model.channel.operation.Operation;
import com.asyncapi.v2._6_0.model.server.Server;
import com.asyncapi.v2.binding.message.MessageBinding;
import com.asyncapi.v2.binding.operation.OperationBinding;
import io.github.stavshamir.springwolf.asyncapi.scanners.bindings.MessageBindingProcessor;
import io.github.stavshamir.springwolf.asyncapi.scanners.bindings.OperationBindingProcessor;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.ChannelMerger;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.ChannelsScanner;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.annotation.AnnotationUtil;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.annotation.AsyncAnnotationScannerUtil;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.operationdata.annotation.AsyncOperation;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.payload.PayloadClassExtractor;
import io.github.stavshamir.springwolf.asyncapi.scanners.classes.ClassScanner;
import io.github.stavshamir.springwolf.asyncapi.types.OperationData;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.Message;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.PayloadReference;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.header.AsyncHeaders;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.header.HeaderReference;
import io.github.stavshamir.springwolf.configuration.AsyncApiDocketService;
import io.github.stavshamir.springwolf.schemas.SchemasService;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public class AsyncAnnotationChannelsScanner<A extends Annotation>
implements ChannelsScanner,
EmbeddedValueResolverAware {
    private static final Logger log = LoggerFactory.getLogger(AsyncAnnotationChannelsScanner.class);
    private final AsyncAnnotationProvider<A> asyncAnnotationProvider;
    private final ClassScanner classScanner;
    private final SchemasService schemasService;
    private final AsyncApiDocketService asyncApiDocketService;
    private final PayloadClassExtractor payloadClassExtractor;
    private final List<OperationBindingProcessor> operationBindingProcessors;
    private final List<MessageBindingProcessor> messageBindingProcessors;
    private StringValueResolver resolver;

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public Map<String, ChannelItem> scan() {
        List<Map.Entry<String, ChannelItem>> channels = this.classScanner.scan().stream().flatMap(this::getAnnotatedMethods).map(this::buildChannelItem).filter(this::isInvalidChannelItem).collect(Collectors.toList());
        return ChannelMerger.merge(channels);
    }

    private Stream<MethodAndAnnotation<A>> getAnnotatedMethods(Class<?> type) {
        Class annotationClass = this.asyncAnnotationProvider.getAnnotation();
        log.debug("Scanning class \"{}\" for @\"{}\" annotated methods", (Object)type.getName(), (Object)annotationClass.getName());
        return Arrays.stream(type.getDeclaredMethods()).filter(method -> !method.isBridge()).filter(method -> AnnotationUtil.findAnnotation(annotationClass, method) != null).peek(method -> log.debug("Mapping method \"{}\" to channels", (Object)method.getName())).flatMap(method -> AnnotationUtil.findAnnotations(annotationClass, method).stream().map(annotation -> new MethodAndAnnotation<Annotation>((Method)method, (Annotation)annotation)));
    }

    private boolean isInvalidChannelItem(Map.Entry<String, ChannelItem> entry) {
        boolean allNonNull;
        Operation publish = entry.getValue().getPublish();
        boolean publishBindingExists = publish != null && publish.getBindings() != null;
        Operation subscribe = entry.getValue().getSubscribe();
        boolean subscribeBindingExists = subscribe != null && subscribe.getBindings() != null;
        boolean bl = allNonNull = entry.getKey() != null && (publishBindingExists || subscribeBindingExists);
        if (!allNonNull) {
            log.warn("Some data fields are null - method (channel={}) will not be documented: {}", (Object)entry.getKey(), (Object)entry.getValue());
        }
        return allNonNull;
    }

    private Map.Entry<String, ChannelItem> buildChannelItem(MethodAndAnnotation<A> methodAndAnnotation) {
        ChannelItem.ChannelItemBuilder channelBuilder = ChannelItem.builder();
        AsyncOperation operationAnnotation = this.asyncAnnotationProvider.getAsyncOperation((Annotation)methodAndAnnotation.annotation());
        String channelName = this.resolver.resolveStringValue(operationAnnotation.channelName());
        Operation operation = this.buildOperation(operationAnnotation, methodAndAnnotation.method(), channelName);
        switch (this.asyncAnnotationProvider.getOperationType()) {
            case PUBLISH: {
                channelBuilder.publish(operation);
                break;
            }
            case SUBSCRIBE: {
                channelBuilder.subscribe(operation);
            }
        }
        List<String> servers = AsyncAnnotationScannerUtil.getServers(operationAnnotation, this.resolver);
        if (servers != null && !servers.isEmpty()) {
            this.validateServers(servers, operation.getOperationId());
            channelBuilder.servers(servers);
        }
        ChannelItem channelItem = channelBuilder.build();
        return Map.entry(channelName, channelItem);
    }

    private Operation buildOperation(AsyncOperation asyncOperation, Method method, String channelName) {
        String description = this.resolver.resolveStringValue(asyncOperation.description());
        if (!StringUtils.hasText((String)description)) {
            description = "Auto-generated description";
        }
        String operationId = channelName + "_" + this.asyncAnnotationProvider.getOperationType().operationName;
        Map<String, OperationBinding> operationBinding = AsyncAnnotationScannerUtil.processOperationBindingFromAnnotation(method, this.operationBindingProcessors);
        HashMap<String, OperationBinding> opBinding = operationBinding != null ? new HashMap<String, OperationBinding>(operationBinding) : null;
        return Operation.builder().description(description).operationId(operationId).message((Object)this.buildMessage(asyncOperation, method)).bindings(opBinding).build();
    }

    private Message buildMessage(AsyncOperation operationData, Method method) {
        Class<?> payloadType = operationData.payloadType() != Object.class ? operationData.payloadType() : this.payloadClassExtractor.extractFrom(method);
        String modelName = this.schemasService.register(payloadType);
        AsyncHeaders asyncHeaders = AsyncAnnotationScannerUtil.getAsyncHeaders(operationData, this.resolver);
        String headerModelName = this.schemasService.register(asyncHeaders);
        Schema schema = payloadType.getAnnotation(Schema.class);
        String description = schema != null ? schema.description() : null;
        Map<String, MessageBinding> messageBinding = AsyncAnnotationScannerUtil.processMessageBindingFromAnnotation(method, this.messageBindingProcessors);
        Message.MessageBuilder builder = Message.builder().name(payloadType.getName()).title(payloadType.getSimpleName()).description(description).payload(PayloadReference.fromModelName(modelName)).headers(HeaderReference.fromModelName(headerModelName)).bindings(messageBinding);
        AsyncAnnotationScannerUtil.processAsyncMessageAnnotation(builder, operationData.message(), this.resolver);
        return builder.build();
    }

    void validateServers(List<String> serversFromOperation, String operationId) {
        if (!serversFromOperation.isEmpty()) {
            Map<String, Server> asyncApiServers = this.asyncApiDocketService.getAsyncApiDocket().getServers();
            if (asyncApiServers == null || asyncApiServers.isEmpty()) {
                throw new IllegalArgumentException(String.format("Operation '%s' defines server refs (%s) but there are no servers defined in this AsyncAPI.", operationId, serversFromOperation));
            }
            for (String server : serversFromOperation) {
                if (asyncApiServers.containsKey(server)) continue;
                throw new IllegalArgumentException(String.format("Operation '%s' defines unknown server ref '%s'. This AsyncApi defines these server(s): %s", operationId, server, asyncApiServers.keySet()));
            }
        }
    }

    public AsyncAnnotationChannelsScanner(AsyncAnnotationProvider<A> asyncAnnotationProvider, ClassScanner classScanner, SchemasService schemasService, AsyncApiDocketService asyncApiDocketService, PayloadClassExtractor payloadClassExtractor, List<OperationBindingProcessor> operationBindingProcessors, List<MessageBindingProcessor> messageBindingProcessors) {
        this.asyncAnnotationProvider = asyncAnnotationProvider;
        this.classScanner = classScanner;
        this.schemasService = schemasService;
        this.asyncApiDocketService = asyncApiDocketService;
        this.payloadClassExtractor = payloadClassExtractor;
        this.operationBindingProcessors = operationBindingProcessors;
        this.messageBindingProcessors = messageBindingProcessors;
    }

    public static interface AsyncAnnotationProvider<A> {
        public Class<A> getAnnotation();

        public AsyncOperation getAsyncOperation(A var1);

        public OperationData.OperationType getOperationType();
    }

    private record MethodAndAnnotation<A>(Method method, A annotation) {
    }
}

