/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.scanners.channels.annotation;

import com.asyncapi.v2.binding.message.MessageBinding;
import com.asyncapi.v2.binding.operation.OperationBinding;
import io.github.stavshamir.springwolf.asyncapi.scanners.bindings.MessageBindingProcessor;
import io.github.stavshamir.springwolf.asyncapi.scanners.bindings.OperationBindingProcessor;
import io.github.stavshamir.springwolf.asyncapi.scanners.bindings.ProcessedMessageBinding;
import io.github.stavshamir.springwolf.asyncapi.scanners.bindings.ProcessedOperationBinding;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.operationdata.annotation.AsyncMessage;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.operationdata.annotation.AsyncOperation;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.Message;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.header.AsyncHeaderSchema;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.header.AsyncHeaders;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

class AsyncAnnotationScannerUtil {
    AsyncAnnotationScannerUtil() {
    }

    public static AsyncHeaders getAsyncHeaders(AsyncOperation op, StringValueResolver resolver) {
        if (op.headers().values().length == 0) {
            return AsyncHeaders.NOT_DOCUMENTED;
        }
        AsyncHeaders asyncHeaders = new AsyncHeaders(op.headers().schemaName());
        Arrays.stream(op.headers().values()).collect(Collectors.groupingBy(AsyncOperation.Headers.Header::name)).forEach((headerName, headers) -> {
            List<String> values = AsyncAnnotationScannerUtil.getHeaderValues(headers, resolver);
            String exampleValue = values.stream().findFirst().orElse(null);
            asyncHeaders.addHeader(AsyncHeaderSchema.headerBuilder().headerName(resolver.resolveStringValue(headerName)).description(AsyncAnnotationScannerUtil.getDescription(headers, resolver)).enumValue(values).example(exampleValue).build());
        });
        return asyncHeaders;
    }

    private static List<String> getHeaderValues(List<AsyncOperation.Headers.Header> value, StringValueResolver resolver) {
        return value.stream().map(AsyncOperation.Headers.Header::value).map(arg_0 -> ((StringValueResolver)resolver).resolveStringValue(arg_0)).sorted().collect(Collectors.toList());
    }

    private static String getDescription(List<AsyncOperation.Headers.Header> value, StringValueResolver resolver) {
        return value.stream().map(AsyncOperation.Headers.Header::description).map(arg_0 -> ((StringValueResolver)resolver).resolveStringValue(arg_0)).filter(StringUtils::hasText).sorted().findFirst().orElse(null);
    }

    public static Map<String, OperationBinding> processOperationBindingFromAnnotation(Method method, List<OperationBindingProcessor> operationBindingProcessors) {
        return operationBindingProcessors.stream().map(operationBindingProcessor -> operationBindingProcessor.process(method)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(ProcessedOperationBinding::getType, ProcessedOperationBinding::getBinding, (e1, e2) -> e1));
    }

    public static Map<String, MessageBinding> processMessageBindingFromAnnotation(Method method, List<MessageBindingProcessor> messageBindingProcessors) {
        return messageBindingProcessors.stream().map(messageBindingProcessor -> messageBindingProcessor.process(method)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(ProcessedMessageBinding::getType, ProcessedMessageBinding::getBinding, (e1, e2) -> e2));
    }

    public static void processAsyncMessageAnnotation(Message.MessageBuilder messageBuilder, AsyncMessage asyncMessage, StringValueResolver resolver) {
        String annotationSchemaFormat;
        String annotationName;
        String annotationMessageId;
        String annotationMessageDescription = resolver.resolveStringValue(asyncMessage.description());
        if (StringUtils.hasText((String)annotationMessageDescription)) {
            messageBuilder.description(annotationMessageDescription);
        }
        if (StringUtils.hasText((String)(annotationMessageId = resolver.resolveStringValue(asyncMessage.messageId())))) {
            messageBuilder.messageId(annotationMessageId);
        }
        if (StringUtils.hasText((String)(annotationName = resolver.resolveStringValue(asyncMessage.name())))) {
            messageBuilder.name(annotationName);
        }
        String schemaFormat = (annotationSchemaFormat = asyncMessage.schemaFormat()) != null ? annotationSchemaFormat : "application/vnd.oai.openapi+json;version=3.0.0";
        messageBuilder.schemaFormat(schemaFormat);
        String annotationTitle = resolver.resolveStringValue(asyncMessage.title());
        if (StringUtils.hasText((String)annotationTitle)) {
            messageBuilder.title(annotationTitle);
        }
    }

    public static List<String> getServers(AsyncOperation op, StringValueResolver resolver) {
        return Arrays.stream(op.servers()).map(arg_0 -> ((StringValueResolver)resolver).resolveStringValue(arg_0)).collect(Collectors.toList());
    }
}

