/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.scanners.channels.annotation;

import com.asyncapi.v2._6_0.model.channel.ChannelItem;
import com.asyncapi.v2._6_0.model.channel.operation.Operation;
import com.asyncapi.v2.binding.channel.ChannelBinding;
import com.asyncapi.v2.binding.message.MessageBinding;
import com.asyncapi.v2.binding.operation.OperationBinding;
import io.github.stavshamir.springwolf.asyncapi.MessageHelper;
import io.github.stavshamir.springwolf.asyncapi.scanners.bindings.BindingFactory;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.SimpleChannelsScanner;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.annotation.AnnotationUtil;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.payload.PayloadClassExtractor;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.Message;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.PayloadReference;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.header.AsyncHeadersBuilder;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.header.HeaderReference;
import io.github.stavshamir.springwolf.schemas.SchemasService;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;

public class ClassLevelAnnotationChannelsScanner<ClassAnnotation extends Annotation, MethodAnnotation extends Annotation>
implements SimpleChannelsScanner.ClassProcessor {
    private static final Logger log = LoggerFactory.getLogger(ClassLevelAnnotationChannelsScanner.class);
    private final Class<ClassAnnotation> classAnnotationClass;
    private final Class<MethodAnnotation> methodAnnotationClass;
    private final BindingFactory<ClassAnnotation> bindingFactory;
    private final AsyncHeadersBuilder asyncHeadersBuilder;
    private final PayloadClassExtractor payloadClassExtractor;
    private final SchemasService schemasService;

    @Override
    public Stream<Map.Entry<String, ChannelItem>> process(Class<?> clazz) {
        log.debug("Scanning class \"{}\" for @\"{}\" annotated methods", (Object)clazz.getName(), (Object)this.classAnnotationClass.getName());
        return Stream.of(clazz).filter(this::isClassAnnotated).flatMap(this::mapClassToChannel);
    }

    private boolean isClassAnnotated(Class<?> component) {
        return AnnotationUtil.findAnnotation(this.classAnnotationClass, component) != null;
    }

    private Set<Method> getAnnotatedMethods(Class<?> clazz) {
        log.debug("Scanning class \"{}\" for @\"{}\" annotated methods", (Object)clazz.getName(), (Object)this.methodAnnotationClass.getName());
        return Arrays.stream(clazz.getDeclaredMethods()).filter(method -> !method.isBridge()).filter(method -> AnnotationUtils.findAnnotation((Method)method, this.methodAnnotationClass) != null).collect(Collectors.toSet());
    }

    private Stream<Map.Entry<String, ChannelItem>> mapClassToChannel(Class<?> component) {
        log.debug("Mapping class \"{}\" to channels", (Object)component.getName());
        ClassAnnotation classAnnotation = AnnotationUtil.findAnnotationOrThrow(this.classAnnotationClass, component);
        Set<Method> annotatedMethods = this.getAnnotatedMethods(component);
        if (annotatedMethods.isEmpty()) {
            return Stream.empty();
        }
        String channelName = this.bindingFactory.getChannelName(classAnnotation);
        String operationId = channelName + "_publish_" + component.getSimpleName();
        ChannelItem channelItem = this.buildChannelItem(classAnnotation, operationId, annotatedMethods);
        return Stream.of(Map.entry(channelName, channelItem));
    }

    private ChannelItem buildChannelItem(ClassAnnotation classAnnotation, String operationId, Set<Method> methods) {
        Object message = this.buildMessageObject(classAnnotation, methods);
        Operation operation = this.buildOperation(classAnnotation, operationId, message);
        return this.buildChannelItem(classAnnotation, operation);
    }

    private Object buildMessageObject(ClassAnnotation classAnnotation, Set<Method> methods) {
        Set<Message> messages = methods.stream().map(method -> {
            Class<?> payloadType = this.payloadClassExtractor.extractFrom((Method)method);
            return this.buildMessage(classAnnotation, payloadType);
        }).collect(Collectors.toSet());
        return MessageHelper.toMessageObjectOrComposition(messages);
    }

    private Message buildMessage(ClassAnnotation classAnnotation, Class<?> payloadType) {
        Map<String, MessageBinding> messageBinding = this.bindingFactory.buildMessageBinding(classAnnotation);
        String modelName = this.schemasService.register(payloadType);
        String headerModelName = this.schemasService.register(this.asyncHeadersBuilder.buildHeaders(payloadType));
        return Message.builder().name(payloadType.getName()).title(payloadType.getSimpleName()).description(null).payload(PayloadReference.fromModelName(modelName)).headers(HeaderReference.fromModelName(headerModelName)).bindings(messageBinding).build();
    }

    private Operation buildOperation(ClassAnnotation classAnnotation, String operationId, Object message) {
        Map<String, OperationBinding> operationBinding = this.bindingFactory.buildOperationBinding(classAnnotation);
        HashMap<String, OperationBinding> opBinding = operationBinding != null ? new HashMap<String, OperationBinding>(operationBinding) : null;
        return Operation.builder().description("Auto-generated description").operationId(operationId).message(message).bindings(opBinding).build();
    }

    private ChannelItem buildChannelItem(ClassAnnotation classAnnotation, Operation operation) {
        Map<String, ChannelBinding> channelBinding = this.bindingFactory.buildChannelBinding(classAnnotation);
        HashMap<String, ChannelBinding> chBinding = channelBinding != null ? new HashMap<String, ChannelBinding>(channelBinding) : null;
        return ChannelItem.builder().bindings(chBinding).publish(operation).build();
    }

    public ClassLevelAnnotationChannelsScanner(Class<ClassAnnotation> classAnnotationClass, Class<MethodAnnotation> methodAnnotationClass, BindingFactory<ClassAnnotation> bindingFactory, AsyncHeadersBuilder asyncHeadersBuilder, PayloadClassExtractor payloadClassExtractor, SchemasService schemasService) {
        this.classAnnotationClass = classAnnotationClass;
        this.methodAnnotationClass = methodAnnotationClass;
        this.bindingFactory = bindingFactory;
        this.asyncHeadersBuilder = asyncHeadersBuilder;
        this.payloadClassExtractor = payloadClassExtractor;
        this.schemasService = schemasService;
    }
}

