/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.scanners.channels.annotation;

import com.asyncapi.v2._6_0.model.channel.ChannelItem;
import com.asyncapi.v2._6_0.model.channel.operation.Operation;
import com.asyncapi.v2.binding.channel.ChannelBinding;
import com.asyncapi.v2.binding.message.MessageBinding;
import com.asyncapi.v2.binding.operation.OperationBinding;
import io.github.stavshamir.springwolf.asyncapi.scanners.bindings.BindingFactory;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.SimpleChannelsScanner;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.annotation.AnnotationUtil;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.payload.PayloadClassExtractor;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.Message;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.PayloadReference;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.header.AsyncHeaders;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.header.HeaderReference;
import io.github.stavshamir.springwolf.schemas.SchemasService;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodLevelAnnotationChannelsScanner<MethodAnnotation extends Annotation>
implements SimpleChannelsScanner.ClassProcessor {
    private static final Logger log = LoggerFactory.getLogger(MethodLevelAnnotationChannelsScanner.class);
    private final Class<MethodAnnotation> methodAnnotationClass;
    private final BindingFactory<MethodAnnotation> bindingFactory;
    private final PayloadClassExtractor payloadClassExtractor;
    private final SchemasService schemasService;

    @Override
    public Stream<Map.Entry<String, ChannelItem>> process(Class<?> clazz) {
        log.debug("Scanning class \"{}\" for @\"{}\" annotated methods", (Object)clazz.getName(), (Object)this.methodAnnotationClass.getName());
        return Arrays.stream(clazz.getDeclaredMethods()).filter(method -> !method.isBridge()).filter(method -> AnnotationUtil.findAnnotation(this.methodAnnotationClass, method) != null).map(this::mapMethodToChannel);
    }

    private Map.Entry<String, ChannelItem> mapMethodToChannel(Method method) {
        log.debug("Mapping method \"{}\" to channels", (Object)method.getName());
        MethodAnnotation annotation = AnnotationUtil.findAnnotationOrThrow(this.methodAnnotationClass, method);
        String channelName = this.bindingFactory.getChannelName(annotation);
        String operationId = channelName + "_publish_" + method.getName();
        Class<?> payload = this.payloadClassExtractor.extractFrom(method);
        ChannelItem channelItem = this.buildChannelItem(annotation, operationId, payload);
        return Map.entry(channelName, channelItem);
    }

    private ChannelItem buildChannelItem(MethodAnnotation annotation, String operationId, Class<?> payloadType) {
        Message message = this.buildMessage(annotation, payloadType);
        Operation operation = this.buildOperation(annotation, operationId, message);
        return this.buildChannelItem(annotation, operation);
    }

    private Message buildMessage(MethodAnnotation annotation, Class<?> payloadType) {
        Map<String, MessageBinding> messageBinding = this.bindingFactory.buildMessageBinding(annotation);
        String modelName = this.schemasService.register(payloadType);
        String headerModelName = this.schemasService.register(AsyncHeaders.NOT_DOCUMENTED);
        return Message.builder().name(payloadType.getName()).title(payloadType.getSimpleName()).description(null).payload(PayloadReference.fromModelName(modelName)).headers(HeaderReference.fromModelName(headerModelName)).bindings(messageBinding).build();
    }

    private Operation buildOperation(MethodAnnotation annotation, String operationId, Message message) {
        Map<String, OperationBinding> operationBinding = this.bindingFactory.buildOperationBinding(annotation);
        HashMap<String, OperationBinding> opBinding = operationBinding != null ? new HashMap<String, OperationBinding>(operationBinding) : null;
        return Operation.builder().description("Auto-generated description").operationId(operationId).message((Object)message).bindings(opBinding).build();
    }

    private ChannelItem buildChannelItem(MethodAnnotation annotation, Operation operation) {
        Map<String, ChannelBinding> channelBinding = this.bindingFactory.buildChannelBinding(annotation);
        HashMap<String, ChannelBinding> chBinding = channelBinding != null ? new HashMap<String, ChannelBinding>(channelBinding) : null;
        return ChannelItem.builder().bindings(chBinding).publish(operation).build();
    }

    public MethodLevelAnnotationChannelsScanner(Class<MethodAnnotation> methodAnnotationClass, BindingFactory<MethodAnnotation> bindingFactory, PayloadClassExtractor payloadClassExtractor, SchemasService schemasService) {
        this.methodAnnotationClass = methodAnnotationClass;
        this.bindingFactory = bindingFactory;
        this.payloadClassExtractor = payloadClassExtractor;
        this.schemasService = schemasService;
    }
}

