/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.scanners.channels.operationdata;

import com.asyncapi.v2._6_0.model.channel.ChannelItem;
import com.asyncapi.v2._6_0.model.channel.operation.Operation;
import com.asyncapi.v2._6_0.model.server.Server;
import com.asyncapi.v2.binding.channel.ChannelBinding;
import com.asyncapi.v2.binding.operation.OperationBinding;
import io.github.stavshamir.springwolf.asyncapi.MessageHelper;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.ChannelsScanner;
import io.github.stavshamir.springwolf.asyncapi.types.OperationData;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.Message;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.PayloadReference;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.header.HeaderReference;
import io.github.stavshamir.springwolf.configuration.AsyncApiDocketService;
import io.github.stavshamir.springwolf.schemas.SchemasService;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@Deprecated(forRemoval=true)
public abstract class AbstractOperationDataScanner
implements ChannelsScanner {
    private static final Logger log = LoggerFactory.getLogger(AbstractOperationDataScanner.class);

    protected abstract SchemasService getSchemaService();

    protected abstract AsyncApiDocketService getAsyncApiDocketService();

    protected abstract List<OperationData> getOperationData();

    protected abstract OperationData.OperationType getOperationType();

    @Override
    public Map<String, ChannelItem> scan() {
        Map<String, List<OperationData>> operationDataGroupedByChannelName = this.getOperationData().stream().filter(this::allFieldsAreNonNull).collect(Collectors.groupingBy(OperationData::getChannelName));
        return operationDataGroupedByChannelName.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.buildChannel((List)entry.getValue())));
    }

    private boolean allFieldsAreNonNull(OperationData operationData) {
        boolean allNonNull;
        boolean bl = allNonNull = operationData.getChannelName() != null && operationData.getPayloadType() != null && operationData.getOperationBinding() != null;
        if (!allNonNull) {
            log.warn("Some data fields are null - this producer will not be documented: {}", (Object)operationData);
        }
        return allNonNull;
    }

    private ChannelItem buildChannel(List<OperationData> operationDataList) {
        Map<String, ? extends ChannelBinding> channelBinding = operationDataList.get(0).getChannelBinding();
        Map<String, ? extends OperationBinding> operationBinding = operationDataList.get(0).getOperationBinding();
        HashMap<String, ? extends OperationBinding> opBinding = operationBinding != null ? new HashMap<String, OperationBinding>(operationBinding) : null;
        HashMap<String, ? extends ChannelBinding> chBinding = channelBinding != null ? new HashMap<String, ChannelBinding>(channelBinding) : null;
        String operationId = operationDataList.get(0).getChannelName() + "_" + this.getOperationType().operationName;
        String description = operationDataList.get(0).getDescription();
        List<String> servers = operationDataList.get(0).getServers();
        if (description.isEmpty()) {
            description = "Auto-generated description";
        }
        Operation operation = Operation.builder().description(description).operationId(operationId).message(this.getMessageObject(operationDataList)).bindings(opBinding).build();
        ChannelItem.ChannelItemBuilder channelBuilder = ChannelItem.builder().bindings(chBinding);
        switch (this.getOperationType()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case PUBLISH: {
                ChannelItem.ChannelItemBuilder channelItemBuilder = channelBuilder.publish(operation);
                break;
            }
            case SUBSCRIBE: {
                ChannelItem.ChannelItemBuilder channelItemBuilder = channelBuilder = channelBuilder.subscribe(operation);
            }
        }
        if (servers != null && !servers.isEmpty()) {
            this.validateServers(servers, operationId);
            channelBuilder.servers(servers);
        }
        return channelBuilder.build();
    }

    private Object getMessageObject(List<OperationData> operationDataList) {
        Set<Message> messages = operationDataList.stream().map(this::buildMessage).collect(Collectors.toSet());
        return MessageHelper.toMessageObjectOrComposition(messages);
    }

    private Message buildMessage(OperationData operationData) {
        Class<?> payloadType = operationData.getPayloadType();
        String modelName = this.getSchemaService().register(payloadType);
        String headerModelName = this.getSchemaService().register(operationData.getHeaders());
        Schema schema = payloadType.getAnnotation(Schema.class);
        String description = schema != null ? schema.description() : null;
        Message.MessageBuilder builder = Message.builder().name(payloadType.getName()).title(payloadType.getSimpleName()).description(description).payload(PayloadReference.fromModelName(modelName)).headers(HeaderReference.fromModelName(headerModelName)).bindings(operationData.getMessageBinding());
        this.processAsyncMessageAnnotation(operationData.getMessage(), builder);
        return builder.build();
    }

    private void processAsyncMessageAnnotation(Message annotationMessage, Message.MessageBuilder builder) {
        if (annotationMessage != null) {
            String title;
            String name;
            builder.messageId(annotationMessage.getMessageId());
            String schemaFormat = annotationMessage.getSchemaFormat() != null ? annotationMessage.getSchemaFormat() : "application/vnd.oai.openapi+json;version=3.0.0";
            builder.schemaFormat(schemaFormat);
            String annotationMessageDescription = annotationMessage.getDescription();
            if (StringUtils.hasText((String)annotationMessageDescription)) {
                builder.description(annotationMessageDescription);
            }
            if (StringUtils.hasText((String)(name = annotationMessage.getName()))) {
                builder.name(name);
            }
            if (StringUtils.hasText((String)(title = annotationMessage.getTitle()))) {
                builder.title(title);
            }
        }
    }

    void validateServers(List<String> serversFromOperation, String operationId) {
        if (!serversFromOperation.isEmpty()) {
            Map<String, Server> asyncApiServers = this.getAsyncApiDocketService().getAsyncApiDocket().getServers();
            if (asyncApiServers == null || asyncApiServers.isEmpty()) {
                throw new IllegalArgumentException(String.format("Operation '%s' defines server refs (%s) but there are no servers defined in this AsyncAPI.", operationId, serversFromOperation));
            }
            for (String server : serversFromOperation) {
                if (asyncApiServers.containsKey(server)) continue;
                throw new IllegalArgumentException(String.format("Operation '%s' defines unknown server ref '%s'. This AsyncApi defines these server(s): %s", operationId, server, asyncApiServers.keySet()));
            }
        }
    }
}

