/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.configuration.properties;

import com.asyncapi.v2._6_0.model.info.Contact;
import com.asyncapi.v2._6_0.model.info.License;
import com.asyncapi.v2._6_0.model.server.Server;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.lang.Nullable;

@ConfigurationProperties(prefix="springwolf")
public class SpringwolfConfigProperties {
    private boolean enabled = true;
    private InitMode initMode = InitMode.FAIL_FAST;
    private boolean useFqn = false;
    @Nullable
    private Endpoint endpoint;
    @Nullable
    private ConfigDocket docket;
    @Nullable
    private Scanner scanner;
    @Nullable
    private Payload payload = new Payload();

    public boolean isEnabled() {
        return this.enabled;
    }

    public InitMode getInitMode() {
        return this.initMode;
    }

    public boolean isUseFqn() {
        return this.useFqn;
    }

    @Nullable
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Nullable
    public ConfigDocket getDocket() {
        return this.docket;
    }

    @Nullable
    public Scanner getScanner() {
        return this.scanner;
    }

    @Nullable
    public Payload getPayload() {
        return this.payload;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setInitMode(InitMode initMode) {
        this.initMode = initMode;
    }

    public void setUseFqn(boolean useFqn) {
        this.useFqn = useFqn;
    }

    public void setEndpoint(@Nullable Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void setDocket(@Nullable ConfigDocket docket) {
        this.docket = docket;
    }

    public void setScanner(@Nullable Scanner scanner) {
        this.scanner = scanner;
    }

    public void setPayload(@Nullable Payload payload) {
        this.payload = payload;
    }

    public static enum InitMode {
        FAIL_FAST,
        BACKGROUND;

    }

    public static class Payload {
        private Map<String, Integer> extractableClasses = Map.of("java.util.function.Consumer", 0, "java.util.function.Supplier", 0, "org.springframework.messaging.Message", 0, "org.apache.kafka.streams.kstream.KStream", 1, "java.util.List", 0, "java.util.Optional", 0);

        public void setExtractableClasses(Map<String, Integer> extractableClasses) {
            this.extractableClasses = extractableClasses.entrySet().stream().filter(entry -> (Integer)entry.getValue() >= 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        public Map<String, Integer> getExtractableClasses() {
            return this.extractableClasses;
        }
    }

    public static class Endpoint {
        @Nullable
        private Actuator actuator;

        @Nullable
        public Actuator getActuator() {
            return this.actuator;
        }

        public void setActuator(@Nullable Actuator actuator) {
            this.actuator = actuator;
        }

        private static class Actuator {
            private boolean enabled = false;

            private Actuator() {
            }

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }
    }

    public static class ConfigDocket {
        @Nullable
        private String basePackage;
        @Nullable
        private String id;
        @Nullable
        private String defaultContentType;
        @Nullable
        private Map<String, Server> servers;
        @Nullable
        private Info info;

        @Nullable
        public String getBasePackage() {
            return this.basePackage;
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        @Nullable
        public String getDefaultContentType() {
            return this.defaultContentType;
        }

        @Nullable
        public Map<String, Server> getServers() {
            return this.servers;
        }

        @Nullable
        public Info getInfo() {
            return this.info;
        }

        public void setBasePackage(@Nullable String basePackage) {
            this.basePackage = basePackage;
        }

        public void setId(@Nullable String id) {
            this.id = id;
        }

        public void setDefaultContentType(@Nullable String defaultContentType) {
            this.defaultContentType = defaultContentType;
        }

        public void setServers(@Nullable Map<String, Server> servers) {
            this.servers = servers;
        }

        public void setInfo(@Nullable Info info) {
            this.info = info;
        }

        public static class Info {
            @Nullable
            private String title;
            @Nullable
            private String version;
            @Nullable
            private String description;
            @Nullable
            private String termsOfService;
            @NestedConfigurationProperty
            @Nullable
            private Contact contact;
            @NestedConfigurationProperty
            @Nullable
            private License license;
            @Nullable
            private Map<String, String> extensionFields = Map.of("x-generator", "springwolf");

            @Nullable
            public String getTitle() {
                return this.title;
            }

            @Nullable
            public String getVersion() {
                return this.version;
            }

            @Nullable
            public String getDescription() {
                return this.description;
            }

            @Nullable
            public String getTermsOfService() {
                return this.termsOfService;
            }

            @Nullable
            public Contact getContact() {
                return this.contact;
            }

            @Nullable
            public License getLicense() {
                return this.license;
            }

            @Nullable
            public Map<String, String> getExtensionFields() {
                return this.extensionFields;
            }

            public void setTitle(@Nullable String title) {
                this.title = title;
            }

            public void setVersion(@Nullable String version) {
                this.version = version;
            }

            public void setDescription(@Nullable String description) {
                this.description = description;
            }

            public void setTermsOfService(@Nullable String termsOfService) {
                this.termsOfService = termsOfService;
            }

            public void setContact(@Nullable Contact contact) {
                this.contact = contact;
            }

            public void setLicense(@Nullable License license) {
                this.license = license;
            }

            public void setExtensionFields(@Nullable Map<String, String> extensionFields) {
                this.extensionFields = extensionFields;
            }
        }
    }

    public static class Scanner {
        @Nullable
        private static AsyncListener asyncListener;
        @Nullable
        private static AsyncPublisher asyncPublisher;
        @Nullable
        private static ConsumerData consumerData;
        @Nullable
        private static ProducerData producerData;

        public static class ProducerData {
            @Deprecated(forRemoval=true)
            private boolean enabled = true;

            @Deprecated
            public boolean isEnabled() {
                return this.enabled;
            }

            @Deprecated
            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }

        public static class ConsumerData {
            @Deprecated(forRemoval=true)
            private boolean enabled = true;

            @Deprecated
            public boolean isEnabled() {
                return this.enabled;
            }

            @Deprecated
            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }

        public static class AsyncPublisher {
            private boolean enabled = true;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }

        public static class AsyncListener {
            private boolean enabled = true;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }
    }
}

