/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.schemas.postprocessor;

import io.github.stavshamir.springwolf.schemas.postprocessor.SchemasPostProcessor;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Map;
import org.springframework.util.StringUtils;

public class AvroSchemaPostProcessor
implements SchemasPostProcessor {
    private static final String SCHEMA_PROPERTY = "schema";
    private static final String SPECIFIC_DATA_PROPERTY = "specificData";
    private static final String SCHEMA_REF = "org.apache.avro.Schema";
    private static final String SPECIFIC_DAT_REF = "org.apache.avro.specific.SpecificData";

    @Override
    public void process(Schema schema, Map<String, Schema> definitions) {
        this.removeAvroSchemas(definitions);
        this.removeAvroProperties(schema);
    }

    private void removeAvroProperties(Schema schema) {
        Map properties = schema.getProperties();
        if (properties != null) {
            Schema schemaPropertySchema = properties.getOrDefault(SCHEMA_PROPERTY, null);
            Schema specificDataPropertySchema = properties.getOrDefault(SPECIFIC_DATA_PROPERTY, null);
            if (schemaPropertySchema != null && specificDataPropertySchema != null && StringUtils.endsWithIgnoreCase((String)schemaPropertySchema.get$ref(), (String)SCHEMA_REF) && StringUtils.endsWithIgnoreCase((String)specificDataPropertySchema.get$ref(), (String)SPECIFIC_DAT_REF)) {
                properties.remove(SCHEMA_PROPERTY);
                properties.remove(SPECIFIC_DATA_PROPERTY);
            }
        }
    }

    private void removeAvroSchemas(Map<String, Schema> definitions) {
        definitions.entrySet().removeIf(entry -> StringUtils.startsWithIgnoreCase((String)((String)entry.getKey()), (String)"org.apache.avro"));
    }
}

