/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.channels;

import io.github.springwolf.asyncapi.v3.model.channel.ChannelObject;
import io.github.springwolf.core.asyncapi.channels.ChannelsService;
import io.github.springwolf.core.asyncapi.scanners.ChannelsScanner;
import io.github.springwolf.core.asyncapi.scanners.channels.ChannelMerger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChannelsService
implements ChannelsService {
    private static final Logger log = LoggerFactory.getLogger(DefaultChannelsService.class);
    private final List<? extends ChannelsScanner> channelsScanners;

    @Override
    public Map<String, ChannelObject> findChannels() {
        ArrayList<Map.Entry<String, ChannelObject>> foundChannelItems = new ArrayList<Map.Entry<String, ChannelObject>>();
        for (ChannelsScanner channelsScanner : this.channelsScanners) {
            try {
                Map<String, ChannelObject> channels = channelsScanner.scan();
                foundChannelItems.addAll(channels.entrySet());
            }
            catch (Exception e) {
                log.error("An error was encountered during channel scanning with {}: {}", new Object[]{channelsScanner, e.getMessage(), e});
            }
        }
        return ChannelMerger.mergeChannels(foundChannelItems);
    }

    public DefaultChannelsService(List<? extends ChannelsScanner> channelsScanners) {
        this.channelsScanners = channelsScanners;
    }
}

