/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.components.examples.walkers.xml;

import io.github.springwolf.core.asyncapi.components.examples.walkers.ExampleValueGenerator;
import io.github.springwolf.core.asyncapi.components.examples.walkers.PropertyExample;
import io.github.springwolf.core.asyncapi.components.examples.walkers.xml.ExampleXmlValueSerializer;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ExampleXmlValueGenerator
implements ExampleValueGenerator<Node, String> {
    private static final Logger log = LoggerFactory.getLogger(ExampleXmlValueGenerator.class);
    private final Set<String> SUPPORTED_CONTENT_TYPES = Set.of("text/xml", "application/xml");
    private final Schema<String> OVERRIDE_SCHEMA = new StringSchema();
    private final ExampleXmlValueSerializer exampleXmlValueSerializer;
    private Document document;
    private final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private final Map<String, Node> exampleCache = new HashMap<String, Node>();

    public ExampleXmlValueGenerator(ExampleXmlValueSerializer exampleXmlValueSerializer) {
        this.exampleXmlValueSerializer = exampleXmlValueSerializer;
    }

    @Override
    public boolean canHandle(String contentType) {
        return this.SUPPORTED_CONTENT_TYPES.contains(contentType);
    }

    @Override
    public void initialize() {
        try {
            this.document = this.createDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String lookupSchemaName(Schema schema) {
        if (schema.getXml() != null) {
            return schema.getXml().getName();
        }
        return schema.getName();
    }

    @Override
    public Node createIntegerExample(Integer value) {
        return this.document.createTextNode(value.toString());
    }

    @Override
    public Node createDoubleExample(Double value) {
        return this.document.createTextNode(value.toString());
    }

    @Override
    public Node createBooleanExample() {
        return this.createBooleanExample(DEFAULT_BOOLEAN_EXAMPLE);
    }

    @Override
    public Node createBooleanExample(Boolean value) {
        return this.document.createTextNode(value.toString());
    }

    @Override
    public Node createIntegerExample() {
        return this.createIntegerExample(DEFAULT_INTEGER_EXAMPLE);
    }

    @Override
    public Node createObjectExample(String name, List<PropertyExample<Node>> properties) {
        if (name == null) {
            throw new IllegalArgumentException("Object name must not be empty");
        }
        try {
            Element rootElement = this.document.createElement(name);
            for (PropertyExample<Node> propertyExample : properties) {
                rootElement.appendChild(this.handlePropertyExample(propertyExample));
            }
            return rootElement;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private Element wrapNode(String name, Node toWrap) {
        Element rootElement = this.document.createElement(name);
        rootElement.appendChild(toWrap);
        return rootElement;
    }

    private Element handlePropertyExample(PropertyExample<Node> propertyExample) throws ParserConfigurationException {
        Node exampleValue = propertyExample.example();
        if (exampleValue instanceof Element) {
            return (Element)exampleValue;
        }
        if (exampleValue instanceof Text) {
            return this.wrapNode(propertyExample.name(), exampleValue);
        }
        throw new IllegalArgumentException("Unsupported type " + exampleValue.getClass().getSimpleName());
    }

    @Override
    public Node createDoubleExample() {
        return this.createDoubleExample(DEFAULT_NUMBER_EXAMPLE);
    }

    @Override
    public Node createDateExample() {
        return this.document.createTextNode("2015-07-20");
    }

    @Override
    public Node createDateTimeExample() {
        return this.document.createTextNode("2015-07-20T15:49:04-07:00");
    }

    @Override
    public Node createEmailExample() {
        return this.document.createTextNode("example@example.com");
    }

    @Override
    public Node createPasswordExample() {
        return this.document.createTextNode("string-password");
    }

    @Override
    public Node createByteExample() {
        return this.document.createTextNode("YmFzZTY0LWV4YW1wbGU=");
    }

    @Override
    public Node createBinaryExample() {
        return this.document.createTextNode("0111010001100101011100110111010000101101011000100110100101101110011000010110010001111001");
    }

    @Override
    public Node createUuidExample() {
        return this.document.createTextNode("3fa85f64-5717-4562-b3fc-2c963f66afa6");
    }

    @Override
    public Node createStringExample() {
        return this.createStringExample("string");
    }

    @Override
    public Node createStringExample(String value) {
        return this.document.createTextNode(value);
    }

    @Override
    public Node createEnumExample(String anEnumValue) {
        return this.createStringExample(anEnumValue);
    }

    @Override
    public Node createUnknownSchemaStringTypeExample(String schemaType) {
        return this.document.createTextNode("unknown schema type: " + schemaType);
    }

    @Override
    public Node createUnknownSchemaStringFormatExample(String schemaFormat) {
        return this.document.createTextNode("unknown string schema format: " + schemaFormat);
    }

    @Override
    public Node createArrayExample(String name, Node arrayItem) {
        return this.wrapNode(name, arrayItem);
    }

    @Override
    public String prepareForSerialization(Schema schema, Node exampleObject) {
        Node objectToWrite;
        if (exampleObject instanceof Element) {
            objectToWrite = exampleObject;
        } else {
            String name = this.lookupSchemaName(schema);
            objectToWrite = this.wrapNode(name, exampleObject);
        }
        try {
            this.document.appendChild(objectToWrite);
            String xml = this.exampleXmlValueSerializer.writeDocumentAsXmlString(this.document);
            this.exampleCache.putIfAbsent(this.getCacheKey(schema), exampleObject);
            schema.setType(this.OVERRIDE_SCHEMA.getType());
            schema.setTypes(this.OVERRIDE_SCHEMA.getTypes());
            return xml;
        }
        catch (TransformerException | DOMException e) {
            log.error("Serialize {}", (Object)schema.getName(), (Object)e);
            return null;
        }
    }

    @Override
    public Node createRaw(Object exampleValue) {
        return this.readXmlString(exampleValue.toString());
    }

    @Override
    public Node getExampleOrNull(Schema schema, Object example) {
        String name = this.getCacheKey(schema);
        if (example instanceof Node) {
            return (Node)example;
        }
        if (this.exampleCache.containsKey(name)) {
            return this.document.importNode(this.exampleCache.get(name), true);
        }
        return null;
    }

    @Override
    public Node createEmptyObjectExample() {
        return this.document.createTextNode("");
    }

    private String getCacheKey(Schema schema) {
        return schema.getName();
    }

    private Document createDocument() throws ParserConfigurationException {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.newDocument();
    }

    private Node readXmlString(String xmlString) {
        try {
            DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(xmlString);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            log.info("Unable to convert example to XMl Node: {}", (Object)xmlString, (Object)e);
            return null;
        }
    }
}

