/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.common;

import io.github.springwolf.asyncapi.v3.bindings.MessageBinding;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageHeaders;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageObject;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessagePayload;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageReference;
import io.github.springwolf.asyncapi.v3.model.schema.MultiFormatSchema;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaReference;
import io.github.springwolf.core.asyncapi.components.ComponentsService;
import io.github.springwolf.core.asyncapi.components.headers.AsyncHeadersBuilder;
import io.github.springwolf.core.asyncapi.scanners.bindings.BindingFactory;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MethodLevelAnnotationScanner<MethodAnnotation extends Annotation> {
    private static final Logger log = LoggerFactory.getLogger(MethodLevelAnnotationScanner.class);
    protected final BindingFactory<MethodAnnotation> bindingFactory;
    protected final AsyncHeadersBuilder asyncHeadersBuilder;
    protected final ComponentsService componentsService;

    protected MessageObject buildMessage(MethodAnnotation annotation, Class<?> payloadType) {
        Map<String, MessageBinding> messageBinding = this.bindingFactory.buildMessageBinding(annotation);
        String modelName = this.componentsService.registerSchema(payloadType);
        String headerModelName = this.componentsService.registerSchema(this.asyncHeadersBuilder.buildHeaders(payloadType));
        MessagePayload payload = MessagePayload.of((MultiFormatSchema)MultiFormatSchema.builder().schema((Object)SchemaReference.fromSchema((String)modelName)).build());
        MessageObject message = MessageObject.builder().messageId(payloadType.getName()).name(payloadType.getName()).title(payloadType.getSimpleName()).description(null).payload(payload).headers(MessageHeaders.of((MessageReference)MessageReference.toSchema((String)headerModelName))).bindings(messageBinding).build();
        this.componentsService.registerMessage(message);
        return message;
    }

    public MethodLevelAnnotationScanner(BindingFactory<MethodAnnotation> bindingFactory, AsyncHeadersBuilder asyncHeadersBuilder, ComponentsService componentsService) {
        this.bindingFactory = bindingFactory;
        this.asyncHeadersBuilder = asyncHeadersBuilder;
        this.componentsService = componentsService;
    }
}

