/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.common.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Set;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotationCollectors;
import org.springframework.core.annotation.MergedAnnotationPredicates;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.RepeatableContainers;
import org.springframework.lang.Nullable;

public class AnnotationScannerUtil {
    private AnnotationScannerUtil() {
    }

    public static <T extends Annotation> T findAnnotationOrThrow(Class<T> annotationClass, AnnotatedElement element) {
        T annotation = AnnotationScannerUtil.findAnnotation(annotationClass, element);
        if (annotation == null) {
            throw new IllegalArgumentException("Method must be annotated with " + element.getClass().getName());
        }
        return annotation;
    }

    @Nullable
    public static <T extends Annotation> T findAnnotation(Class<T> annotationClass, AnnotatedElement element) {
        Set<T> annotations = AnnotationScannerUtil.findAnnotations(annotationClass, element);
        return (T)((Annotation)annotations.stream().findFirst().orElse(null));
    }

    public static <T extends Annotation> Set<T> findAnnotations(Class<T> annotationClass, AnnotatedElement element) {
        return (Set)MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY, (RepeatableContainers)RepeatableContainers.standardRepeatables()).stream(annotationClass).filter(MergedAnnotationPredicates.firstRunOf(MergedAnnotation::getAggregateIndex)).collect(MergedAnnotationCollectors.toAnnotationSet());
    }
}

