/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.github.springwolf.asyncapi.v3.jackson.AsyncApiSerializerService;
import io.github.springwolf.asyncapi.v3.model.AsyncAPI;
import io.github.springwolf.core.asyncapi.AsyncApiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AsyncApiController {
    private static final Logger log = LoggerFactory.getLogger(AsyncApiController.class);
    private final AsyncApiService asyncApiService;
    private final AsyncApiSerializerService serializer;

    @GetMapping(path={"${springwolf.paths.docs:/springwolf/docs}", "${springwolf.paths.docs:/springwolf/docs}.json"}, produces={"application/json"})
    public String asyncApiJson() throws JsonProcessingException {
        log.debug("Returning AsyncApi.json document");
        AsyncAPI asyncAPI = this.asyncApiService.getAsyncAPI();
        return this.serializer.toJsonString((Object)asyncAPI);
    }

    @GetMapping(path={"${springwolf.paths.docs:/springwolf/docs}.yaml"}, produces={"application/yaml"})
    public String asyncApiYaml() throws JsonProcessingException {
        log.debug("Returning AsyncApi.yaml document");
        AsyncAPI asyncAPI = this.asyncApiService.getAsyncAPI();
        return this.serializer.toYaml((Object)asyncAPI);
    }

    public AsyncApiController(AsyncApiService asyncApiService, AsyncApiSerializerService serializer) {
        this.asyncApiService = asyncApiService;
        this.serializer = serializer;
    }
}

