/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.plugins.kafka.asyncapi.scanners.bindings.operations;

import io.github.springwolf.asyncapi.v3.bindings.OperationBinding;
import io.github.springwolf.asyncapi.v3.bindings.kafka.KafkaOperationBinding;
import io.github.springwolf.asyncapi.v3.model.schema.Schema;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaObject;
import io.github.springwolf.core.asyncapi.scanners.bindings.operations.AbstractOperationBindingProcessor;
import io.github.springwolf.core.asyncapi.scanners.bindings.operations.ProcessedOperationBinding;
import io.github.springwolf.plugins.kafka.asyncapi.annotations.KafkaAsyncOperationBinding;
import io.github.springwolf.plugins.kafka.asyncapi.scanners.common.KafkaListenerUtil;
import org.springframework.util.StringUtils;

public class KafkaOperationBindingProcessor
extends AbstractOperationBindingProcessor<KafkaAsyncOperationBinding> {
    protected ProcessedOperationBinding mapToOperationBinding(KafkaAsyncOperationBinding bindingAnnotation) {
        String clientId = this.resolveOrNull(bindingAnnotation.clientId());
        SchemaObject clientIdSchema = KafkaListenerUtil.buildKafkaClientIdSchema(clientId);
        String groupId = this.resolveOrNull(bindingAnnotation.groupId());
        SchemaObject groupIdSchema = KafkaListenerUtil.buildKafkaGroupIdSchema(groupId);
        KafkaOperationBinding.KafkaOperationBindingBuilder kafkaOperationBindingBuilder = KafkaOperationBinding.builder();
        kafkaOperationBindingBuilder.clientId((Schema)clientIdSchema).groupId((Schema)groupIdSchema);
        String bindingVersion = this.resolveOrNull(bindingAnnotation.bindingVersion());
        if (StringUtils.hasText((String)bindingVersion)) {
            kafkaOperationBindingBuilder.bindingVersion(bindingVersion);
        }
        return new ProcessedOperationBinding(bindingAnnotation.type(), (OperationBinding)kafkaOperationBindingBuilder.build());
    }
}

