/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.Stripper;
import io.github.zlika.reproducible.TarBzStripper;
import io.github.zlika.reproducible.TarGzStripper;
import io.github.zlika.reproducible.TarStripper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

final class SmartTarStripper
implements Stripper {
    private final boolean overwrite;

    public SmartTarStripper(boolean overwrite) {
        this.overwrite = overwrite;
    }

    @Override
    public void strip(File file, File stripped) throws IOException {
        Stripper stripper = SmartTarStripper.findImplementation(file);
        stripper.strip(file, stripped);
        if (this.overwrite) {
            Files.move(stripped.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static Stripper findImplementation(File file) {
        String name = file.getName();
        TarStripper impl = new TarStripper();
        if (name.endsWith(".tar.gz")) {
            impl = new TarGzStripper();
        }
        if (name.endsWith(".tar.bz2")) {
            impl = new TarBzStripper();
        }
        return impl;
    }
}

