/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.FileUtils;
import io.github.zlika.reproducible.Stripper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class TarStripper
implements Stripper {
    protected TarArchiveInputStream createInputStream(File in) throws FileNotFoundException, IOException {
        return new TarArchiveInputStream((InputStream)new FileInputStream(in));
    }

    protected TarArchiveOutputStream createOutputStream(File out) throws FileNotFoundException, IOException {
        return new TarArchiveOutputStream((OutputStream)new FileOutputStream(out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void strip(File in, File out) throws IOException {
        Path tmp = Files.createTempDirectory("tmp-" + in.getName(), new FileAttribute[0]);
        List<TarArchiveEntry> sortedNames = new ArrayList<TarArchiveEntry>();
        try (TarArchiveInputStream tar = this.createInputStream(in);
             TarArchiveOutputStream tout = this.createOutputStream(out);){
            TarArchiveEntry entry;
            while ((entry = tar.getNextTarEntry()) != null) {
                sortedNames.add(entry);
                File copyTo = new File(tmp.toFile(), entry.getName());
                if (entry.isDirectory()) {
                    FileUtils.mkdirs(copyTo);
                    continue;
                }
                File destParent = copyTo.getParentFile();
                FileUtils.mkdirs(destParent);
                Files.copy((InputStream)tar, copyTo.toPath(), new CopyOption[0]);
            }
            sortedNames = this.sortTarEntries(sortedNames);
            for (TarArchiveEntry sortedEntry : sortedNames) {
                File copyFrom = new File(tmp.toFile(), sortedEntry.getName());
                if (!sortedEntry.isDirectory()) {
                    byte[] fileContent = Files.readAllBytes(copyFrom.toPath());
                    sortedEntry.setSize((long)fileContent.length);
                    tout.putArchiveEntry((ArchiveEntry)this.filterTarEntry(sortedEntry));
                    tout.write(fileContent);
                    tout.closeArchiveEntry();
                    continue;
                }
                tout.putArchiveEntry((ArchiveEntry)this.filterTarEntry(sortedEntry));
                tout.closeArchiveEntry();
            }
        }
        finally {
            org.codehaus.plexus.util.FileUtils.deleteDirectory((File)tmp.toFile());
        }
    }

    private List<TarArchiveEntry> sortTarEntries(List<TarArchiveEntry> sortedNames) {
        return sortedNames.stream().sorted((a, b) -> a.getName().compareTo(b.getName())).collect(Collectors.toList());
    }

    private TarArchiveEntry filterTarEntry(TarArchiveEntry entry) {
        entry.setModTime(0L);
        entry.setGroupId(0);
        entry.setUserId(0);
        entry.setUserName("");
        entry.setGroupName("");
        if (entry.isDirectory()) {
            entry.setMode(16877);
        } else {
            entry.setMode(33188);
        }
        return entry;
    }
}

