/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.Stripper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;

final class JaxbObjectFactoryFixer
implements Stripper {
    private static final String END_OF_METHOD = "    }";
    private final Charset charset;

    public JaxbObjectFactoryFixer(Charset charset) {
        this.charset = charset;
    }

    @Override
    public void strip(File in, File out) throws IOException {
        String inContent = new String(Files.readAllBytes(in.toPath()), this.charset);
        if (!this.checkIsXjcObjectFactoryFile(inContent)) {
            Files.copy(in.toPath(), out.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return;
        }
        StringBuilder builder = new StringBuilder();
        int startMethodIndex = this.getStartMethodIndex(inContent);
        builder.append(inContent.substring(0, startMethodIndex));
        List<String> methods = this.getMethodBodies(inContent, startMethodIndex);
        String footer = methods.get(methods.size() - 1);
        methods.remove(methods.size() - 1);
        methods.stream().sorted().forEach(method -> builder.append((String)method));
        builder.append(footer);
        Files.write(out.toPath(), builder.toString().getBytes(this.charset), new OpenOption[0]);
    }

    private int getStartMethodIndex(String content) {
        return content.indexOf(END_OF_METHOD, content.indexOf("public ObjectFactory()")) + END_OF_METHOD.length();
    }

    private List<String> getMethodBodies(String content, int startMethodIndex) {
        int nextIndex;
        ArrayList<String> methods = new ArrayList<String>();
        int currentIndex = startMethodIndex;
        while ((nextIndex = content.indexOf(END_OF_METHOD, currentIndex)) >= 0) {
            methods.add(content.substring(currentIndex, nextIndex += END_OF_METHOD.length()));
            currentIndex = nextIndex;
        }
        methods.add(content.substring(currentIndex));
        return methods;
    }

    private boolean checkIsXjcObjectFactoryFile(String content) {
        return content.contains("JavaTM Architecture for XML Binding") && content.contains("public ObjectFactory()");
    }
}

