/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.ArchiveStripper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.time.LocalDateTime;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;

public class CompressedArchiveStripper
extends ArchiveStripper {
    public CompressedArchiveStripper(LocalDateTime reproducibleDateTime) {
        super(reproducibleDateTime);
    }

    @Override
    void strip(InputStream in, OutputStream out, Path tmp) throws IOException, ArchiveException, CompressorException {
        String format = CompressorStreamFactory.detect((InputStream)in);
        CompressorStreamFactory compressorFactory = CompressorStreamFactory.getSingleton();
        try (BufferedInputStream cis = new BufferedInputStream((InputStream)compressorFactory.createCompressorInputStream(format, in));
             BufferedOutputStream cout = new BufferedOutputStream((OutputStream)compressorFactory.createCompressorOutputStream(format, out));){
            super.strip(cis, cout, tmp);
        }
    }
}

