/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.Stripper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class OverwriteStripper
implements Stripper {
    private final boolean overwrite;
    private final Stripper stripper;

    public OverwriteStripper(boolean overwrite, Stripper stripper) {
        this.overwrite = overwrite;
        this.stripper = stripper;
    }

    @Override
    public void strip(File in, File out) throws IOException {
        this.stripper.strip(in, out);
        if (this.overwrite) {
            Files.move(out.toPath(), in.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

