/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.ArchiveStripper;
import io.github.zlika.reproducible.CompressedArchiveStripper;
import io.github.zlika.reproducible.Stripper;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;

final class SmartArchiveStripper
implements Stripper {
    private final LocalDateTime reproducibleDateTime;

    public SmartArchiveStripper(LocalDateTime reproducibleDateTime) {
        this.reproducibleDateTime = reproducibleDateTime;
    }

    @Override
    public void strip(File file, File stripped) throws IOException {
        Stripper stripper = this.findImplementation(file);
        stripper.strip(file, stripped);
    }

    private Stripper findImplementation(File file) {
        String name = file.getName();
        if (name.endsWith(".tar.gz") || name.endsWith(".tar.bz2")) {
            return new CompressedArchiveStripper(this.reproducibleDateTime);
        }
        return new ArchiveStripper(this.reproducibleDateTime);
    }
}

