/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.metrics;

import io.github.detekt.metrics.ComplexityMetric;
import io.gitlab.arturbosch.detekt.api.Detektion;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/github/detekt/metrics/ComplexityReportGenerator;", "", "complexityMetric", "Lio/github/detekt/metrics/ComplexityMetric;", "(Lio/github/detekt/metrics/ComplexityMetric;)V", "commentSourceRatio", "", "mccPerThousandLines", "numberOfSmells", "smellPerThousandLines", "cannotGenerate", "", "generate", "", "", "Factory", "detekt-metrics"})
public final class ComplexityReportGenerator {
    private int numberOfSmells;
    private int smellPerThousandLines;
    private int mccPerThousandLines;
    private int commentSourceRatio;
    private final ComplexityMetric complexityMetric;
    public static final Factory Factory = new Factory(null);

    @Nullable
    public final List<String> generate() {
        String string;
        if (this.cannotGenerate()) {
            return null;
        }
        Object[] objectArray = new String[10];
        String string2 = "%,d lines of code (loc)";
        Locale locale = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
        Locale locale2 = locale;
        Object[] objectArray2 = new Object[]{this.complexityMetric.getLoc()};
        int n = 0;
        Object[] objectArray3 = objectArray;
        Object[] objectArray4 = objectArray;
        boolean bl = false;
        String string3 = String.format(locale2, string2, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(locale, this, *args)");
        objectArray3[n] = string = string3;
        string2 = "%,d source lines of code (sloc)";
        Locale locale3 = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale3, (String)"Locale.US");
        locale2 = locale3;
        objectArray2 = new Object[]{this.complexityMetric.getSloc()};
        n = 1;
        objectArray3 = objectArray4;
        bl = false;
        String string4 = String.format(locale2, string2, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(locale, this, *args)");
        objectArray3[n] = string = string4;
        string2 = "%,d logical lines of code (lloc)";
        Locale locale4 = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale4, (String)"Locale.US");
        locale2 = locale4;
        objectArray2 = new Object[]{this.complexityMetric.getLloc()};
        n = 2;
        objectArray3 = objectArray4;
        bl = false;
        String string5 = String.format(locale2, string2, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(locale, this, *args)");
        objectArray3[n] = string = string5;
        string2 = "%,d comment lines of code (cloc)";
        Locale locale5 = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale5, (String)"Locale.US");
        locale2 = locale5;
        objectArray2 = new Object[]{this.complexityMetric.getCloc()};
        n = 3;
        objectArray3 = objectArray4;
        bl = false;
        String string6 = String.format(locale2, string2, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"java.lang.String.format(locale, this, *args)");
        objectArray3[n] = string = string6;
        string2 = "%,d cyclomatic complexity (mcc)";
        Locale locale6 = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale6, (String)"Locale.US");
        locale2 = locale6;
        objectArray2 = new Object[]{this.complexityMetric.getMcc()};
        n = 4;
        objectArray3 = objectArray4;
        bl = false;
        String string7 = String.format(locale2, string2, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"java.lang.String.format(locale, this, *args)");
        objectArray3[n] = string = string7;
        string2 = "%,d cognitive complexity";
        Locale locale7 = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale7, (String)"Locale.US");
        locale2 = locale7;
        objectArray2 = new Object[]{this.complexityMetric.getCognitiveComplexity()};
        n = 5;
        objectArray3 = objectArray4;
        bl = false;
        String string8 = String.format(locale2, string2, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"java.lang.String.format(locale, this, *args)");
        objectArray3[n] = string = string8;
        string2 = "%,d number of total code smells";
        Locale locale8 = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale8, (String)"Locale.US");
        locale2 = locale8;
        objectArray2 = new Object[]{this.numberOfSmells};
        n = 6;
        objectArray3 = objectArray4;
        bl = false;
        String string9 = String.format(locale2, string2, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"java.lang.String.format(locale, this, *args)");
        objectArray3[n] = string = string9;
        string2 = "%,d%% comment source ratio";
        Locale locale9 = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale9, (String)"Locale.US");
        locale2 = locale9;
        objectArray2 = new Object[]{this.commentSourceRatio};
        n = 7;
        objectArray3 = objectArray4;
        bl = false;
        String string10 = String.format(locale2, string2, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"java.lang.String.format(locale, this, *args)");
        objectArray3[n] = string = string10;
        string2 = "%,d mcc per 1,000 lloc";
        Locale locale10 = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale10, (String)"Locale.US");
        locale2 = locale10;
        objectArray2 = new Object[]{this.mccPerThousandLines};
        n = 8;
        objectArray3 = objectArray4;
        bl = false;
        String string11 = String.format(locale2, string2, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"java.lang.String.format(locale, this, *args)");
        objectArray3[n] = string = string11;
        string2 = "%,d code smells per 1,000 lloc";
        Locale locale11 = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale11, (String)"Locale.US");
        locale2 = locale11;
        objectArray2 = new Object[]{this.smellPerThousandLines};
        n = 9;
        objectArray3 = objectArray4;
        bl = false;
        String string12 = String.format(locale2, string2, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"java.lang.String.format(locale, this, *args)");
        objectArray3[n] = string = string12;
        return CollectionsKt.listOf((Object[])objectArray4);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean cannotGenerate() {
        void var3_4;
        int n;
        void $this$sumBy$iv;
        if (SetsKt.setOf((Object[])new Integer[]{this.complexityMetric.getMcc(), this.complexityMetric.getCloc(), this.complexityMetric.getCognitiveComplexity()}).contains(null)) {
            return true;
        }
        if (this.complexityMetric.getLloc() == null) return true;
        Integer n2 = this.complexityMetric.getLloc();
        if (n2 != null && n2 == 0) {
            return true;
        }
        if (this.complexityMetric.getSloc() == null) return true;
        Integer n3 = this.complexityMetric.getSloc();
        if (n3 != null && n3 == 0) {
            return true;
        }
        Iterable iterable = this.complexityMetric.getFindings();
        ComplexityReportGenerator complexityReportGenerator = this;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            void it;
            Map.Entry entry = (Map.Entry)element$iv;
            n = sum$iv;
            boolean bl = false;
            int n4 = ((List)it.getValue()).size();
            sum$iv = n + n4;
        }
        complexityReportGenerator.numberOfSmells = n = var3_4;
        this.smellPerThousandLines = this.numberOfSmells * 1000 / this.complexityMetric.getLloc();
        Integer n5 = this.complexityMetric.getMcc();
        if (n5 == null) {
            Intrinsics.throwNpe();
        }
        this.mccPerThousandLines = n5 * 1000 / this.complexityMetric.getLloc();
        Integer n6 = this.complexityMetric.getCloc();
        if (n6 == null) {
            Intrinsics.throwNpe();
        }
        this.commentSourceRatio = n6 * 100 / this.complexityMetric.getSloc();
        return false;
    }

    public ComplexityReportGenerator(@NotNull ComplexityMetric complexityMetric) {
        Intrinsics.checkParameterIsNotNull((Object)complexityMetric, (String)"complexityMetric");
        this.complexityMetric = complexityMetric;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/detekt/metrics/ComplexityReportGenerator$Factory;", "", "()V", "create", "Lio/github/detekt/metrics/ComplexityReportGenerator;", "detektion", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "detekt-metrics"})
    public static final class Factory {
        @NotNull
        public final ComplexityReportGenerator create(@NotNull Detektion detektion) {
            Intrinsics.checkParameterIsNotNull((Object)detektion, (String)"detektion");
            return new ComplexityReportGenerator(new ComplexityMetric(detektion));
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

