/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/Deprecation;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "defaultRuleIdAliases", "", "", "getDefaultRuleIdAliases", "()Ljava/util/Set;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "hasDeprecationCompilerWarnings", "", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "visitElement", "", "detekt-rules"})
public final class Deprecation
extends Rule {
    @NotNull
    private final Issue issue;
    @NotNull
    private final Set<String> defaultRuleIdAliases;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @NotNull
    public Set<String> getDefaultRuleIdAliases() {
        return this.defaultRuleIdAliases;
    }

    public void visitElement(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        if (this.hasDeprecationCompilerWarnings(element)) {
            Entity entity = element instanceof KtNamedDeclaration ? Entity.Companion.atName((KtNamedDeclaration)element) : Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)element, (int)0, (int)2, null);
            this.report((Finding)new CodeSmell(this.getIssue(), entity, element + " is deprecated.", null, null, 24, null));
        }
        super.visitElement(element);
    }

    private final boolean hasDeprecationCompilerWarnings(PsiElement element) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.getBindingContext().getDiagnostics().forElement(element);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Diagnostic it = (Diagnostic)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.DEPRECATION)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    public Deprecation(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("Deprecation", Severity.Defect, "Deprecated elements should not be used.", Debt.Companion.getTWENTY_MINS());
        this.defaultRuleIdAliases = SetsKt.setOf((Object)"DEPRECATION");
    }
}

