/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.github.detekt.metrics.CyclomaticComplexity;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdRule;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.rules.JunkKt;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0012\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\f\u0010\u0019\u001a\u00020\b*\u00020\u0014H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/ComplexMethod;", "Lio/gitlab/arturbosch/detekt/api/ThresholdRule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "threshold", "", "(Lio/gitlab/arturbosch/detekt/api/Config;I)V", "ignoreNestingFunctions", "", "ignoreSimpleWhenEntries", "ignoreSingleWhenExpression", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "nestingFunctions", "", "", "hasSingleWhenExpression", "bodyExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "returnsWhenExpression", "Companion", "detekt-rules"})
public final class ComplexMethod
extends ThresholdRule {
    @NotNull
    private final Issue issue;
    private final boolean ignoreSingleWhenExpression;
    private final boolean ignoreSimpleWhenEntries;
    private final boolean ignoreNestingFunctions;
    private final Set<String> nestingFunctions;
    public static final int DEFAULT_THRESHOLD_METHOD_COMPLEXITY = 15;
    @NotNull
    public static final String IGNORE_SINGLE_WHEN_EXPRESSION = "ignoreSingleWhenExpression";
    @NotNull
    public static final String IGNORE_SIMPLE_WHEN_ENTRIES = "ignoreSimpleWhenEntries";
    @NotNull
    public static final String IGNORE_NESTING_FUNCTIONS = "ignoreNestingFunctions";
    @NotNull
    public static final String NESTING_FUNCTIONS = "nestingFunctions";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        if (this.ignoreSingleWhenExpression && this.hasSingleWhenExpression(function.getBodyExpression())) {
            return;
        }
        int complexity2 = CyclomaticComplexity.Companion.calculate((KtElement)function, (Function1)new Function1<CyclomaticComplexity.Config, Unit>(this){
            final /* synthetic */ ComplexMethod this$0;

            public final void invoke(@NotNull CyclomaticComplexity.Config $this$calculate) {
                Intrinsics.checkParameterIsNotNull((Object)$this$calculate, (String)"$receiver");
                $this$calculate.setIgnoreSimpleWhenEntries(ComplexMethod.access$getIgnoreSimpleWhenEntries$p(this.this$0));
                $this$calculate.setIgnoreNestingFunctions(ComplexMethod.access$getIgnoreNestingFunctions$p(this.this$0));
                $this$calculate.setNestingFunctions(ComplexMethod.access$getNestingFunctions$p(this.this$0));
            }
            {
                this.this$0 = complexMethod;
                super(1);
            }
        });
        if (complexity2 >= this.getThreshold()) {
            this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)function), new Metric("MCC", complexity2, this.getThreshold(), false, 0, 24, null), "The function " + function.getNameAsSafeName() + " appears to be too complex (" + complexity2 + "). " + "Defined complexity threshold for methods is set to '" + this.getThreshold() + '\'', null, 16, null));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasSingleWhenExpression(KtExpression bodyExpression) {
        if (bodyExpression instanceof KtBlockExpression && ((KtBlockExpression)bodyExpression).getStatements().size() == 1) {
            List list = ((KtBlockExpression)bodyExpression).getStatements();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"bodyExpression.statements");
            KtExpression statement = (KtExpression)CollectionsKt.single((List)list);
            if (statement instanceof KtWhenExpression) return true;
            KtExpression ktExpression = statement;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"statement");
            if (!this.returnsWhenExpression(ktExpression)) return false;
            return true;
        }
        if (!(bodyExpression instanceof KtWhenExpression)) return false;
        return true;
    }

    private final boolean returnsWhenExpression(@NotNull KtExpression $this$returnsWhenExpression) {
        return $this$returnsWhenExpression instanceof KtReturnExpression && ((KtReturnExpression)$this$returnsWhenExpression).getReturnedExpression() instanceof KtWhenExpression;
    }

    public ComplexMethod(@NotNull Config config, int threshold) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, threshold);
        this.issue = new Issue("ComplexMethod", Severity.Maintainability, "Prefer splitting up complex methods into smaller, easier to understand methods.", Debt.Companion.getTWENTY_MINS());
        this.ignoreSingleWhenExpression = (Boolean)this.valueOrDefault(IGNORE_SINGLE_WHEN_EXPRESSION, false);
        this.ignoreSimpleWhenEntries = (Boolean)this.valueOrDefault(IGNORE_SIMPLE_WHEN_ENTRIES, false);
        this.ignoreNestingFunctions = (Boolean)this.valueOrDefault(IGNORE_NESTING_FUNCTIONS, false);
        this.nestingFunctions = CollectionsKt.toSet((Iterable)JunkKt.valueOrDefaultCommaSeparated((Config)this, NESTING_FUNCTIONS, CollectionsKt.toList((Iterable)CyclomaticComplexity.Companion.getDEFAULT_NESTING_FUNCTIONS())));
    }

    public /* synthetic */ ComplexMethod(Config config, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        if ((n2 & 2) != 0) {
            n = 15;
        }
        this(config, n);
    }

    public ComplexMethod() {
        this(null, 0, 3, null);
    }

    public static final /* synthetic */ boolean access$getIgnoreSimpleWhenEntries$p(ComplexMethod $this) {
        return $this.ignoreSimpleWhenEntries;
    }

    public static final /* synthetic */ boolean access$getIgnoreNestingFunctions$p(ComplexMethod $this) {
        return $this.ignoreNestingFunctions;
    }

    public static final /* synthetic */ Set access$getNestingFunctions$p(ComplexMethod $this) {
        return $this.nestingFunctions;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/ComplexMethod$Companion;", "", "()V", "DEFAULT_THRESHOLD_METHOD_COMPLEXITY", "", "IGNORE_NESTING_FUNCTIONS", "", "IGNORE_SIMPLE_WHEN_ENTRIES", "IGNORE_SINGLE_WHEN_EXPRESSION", "NESTING_FUNCTIONS", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

