/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.coroutines;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessorsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002J\f\u0010\u0010\u001a\u00020\u000e*\u00020\u000fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/rules/coroutines/RedundantSuspendModifier;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "hasSuspendCalls", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isValidCandidateExpression", "detekt-rules"})
public final class RedundantSuspendModifier
extends Rule {
    @NotNull
    private final Issue issue;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        void result$iv$iv$iv;
        void $this$anyDescendantOfType$iv;
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        KtModifierList ktModifierList = function.getModifierList();
        if (ktModifierList == null || (ktModifierList = ktModifierList.getModifier(KtTokens.SUSPEND_KEYWORD)) == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktModifierList, (String)"function.modifierList?.g\u2026USPEND_KEYWORD) ?: return");
        KtModifierList suspendModifier = ktModifierList;
        if (!function.hasBody()) {
            return;
        }
        if (function.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            return;
        }
        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.FUNCTION, (Object)function);
        if (simpleFunctionDescriptor == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleFunctionDescriptor, (String)"bindingContext[BindingCo\u2026TION, function] ?: return");
        SimpleFunctionDescriptor descriptor = simpleFunctionDescriptor;
        if (descriptor.getModality() == Modality.OPEN) {
            return;
        }
        PsiElement psiElement = (PsiElement)function;
        Function1 predicate$iv = (Function1)new Function1<KtExpression, Boolean>(this){
            final /* synthetic */ RedundantSuspendModifier this$0;

            public final boolean invoke(@NotNull KtExpression it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return RedundantSuspendModifier.access$hasSuspendCalls(this.this$0, it);
            }
            {
                this.this$0 = redundantSuspendModifier;
                super(1);
            }
        };
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, (Ref.ObjectRef)result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                if (element instanceof KtExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        if ((PsiElement)result$iv$iv$iv.element != null) {
            return;
        }
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)suspendModifier, (int)0, (int)2, null), "When expression contains redundant `else` case.", null, null, 24, null));
    }

    private final boolean isValidCandidateExpression(@NotNull KtExpression $this$isValidCandidateExpression) {
        if ($this$isValidCandidateExpression instanceof KtOperationReferenceExpression || $this$isValidCandidateExpression instanceof KtForExpression) {
            return true;
        }
        if ($this$isValidCandidateExpression instanceof KtProperty || $this$isValidCandidateExpression instanceof KtNameReferenceExpression) {
            return true;
        }
        PsiElement parent = $this$isValidCandidateExpression.getParent();
        if (parent instanceof KtCallExpression && Intrinsics.areEqual((Object)((KtCallExpression)parent).getCalleeExpression(), (Object)$this$isValidCandidateExpression)) {
            return true;
        }
        return $this$isValidCandidateExpression instanceof KtCallExpression && ((KtCallExpression)$this$isValidCandidateExpression).getCalleeExpression() instanceof KtCallExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasSuspendCalls(@NotNull KtExpression $this$hasSuspendCalls) {
        String s;
        PropertyDescriptor propertyDescriptor;
        ResolvedCall resolvedCall;
        if (!this.isValidCandidateExpression($this$hasSuspendCalls)) {
            return false;
        }
        KtExpression ktExpression = $this$hasSuspendCalls;
        if (ktExpression instanceof KtForExpression) {
            boolean bl;
            ResolvedCall iteratorResolvedCall = (ResolvedCall)this.getBindingContext().get((ReadOnlySlice)BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, (Object)((KtForExpression)$this$hasSuspendCalls).getLoopRange());
            ResolvedCall resolvedCall2 = (ResolvedCall)this.getBindingContext().get((ReadOnlySlice)BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, (Object)((KtForExpression)$this$hasSuspendCalls).getLoopRange());
            ResolvedCall loopRangeNextResolvedCall = (ResolvedCall)this.getBindingContext().get((ReadOnlySlice)BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, (Object)((KtForExpression)$this$hasSuspendCalls).getLoopRange());
            Iterable $this$any$iv = CollectionsKt.listOf((Object[])new ResolvedCall[]{iteratorResolvedCall, resolvedCall2, loopRangeNextResolvedCall});
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                ResolvedCall it = (ResolvedCall)element$iv;
                boolean bl2 = false;
                ResolvedCall resolvedCall3 = it;
                if (resolvedCall3 != null && (resolvedCall3 = (FunctionDescriptor)resolvedCall3.getResultingDescriptor()) != null && resolvedCall3.isSuspend()) {
                    return true;
                }
                bl = false;
            } while (!bl);
            return true;
        }
        if (ktExpression instanceof KtProperty) {
            boolean bl;
            VariableDescriptorWithAccessors variableDescriptor;
            Object object;
            if (!((KtProperty)$this$hasSuspendCalls).hasDelegateExpression()) return false;
            Object object2 = this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)$this$hasSuspendCalls);
            if (!(object2 instanceof VariableDescriptorWithAccessors)) {
                object2 = null;
            }
            if ((object = (variableDescriptor = (VariableDescriptorWithAccessors)object2)) == null || (object = VariableDescriptorWithAccessorsKt.getAccessors((VariableDescriptorWithAccessors)object)) == null) {
                object = CollectionsKt.emptyList();
            }
            Object object3 = object;
            Iterable $this$any$iv = (Iterable)object3;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                FunctionDescriptor delegatedFunctionDescriptor;
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                VariableAccessorDescriptor accessor = (VariableAccessorDescriptor)element$iv;
                boolean bl3 = false;
                ResolvedCall resolvedCall4 = (ResolvedCall)this.getBindingContext().get((ReadOnlySlice)BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, (Object)accessor);
                FunctionDescriptor functionDescriptor = delegatedFunctionDescriptor = resolvedCall4 != null ? (FunctionDescriptor)resolvedCall4.getResultingDescriptor() : null;
                if (functionDescriptor != null && functionDescriptor.isSuspend()) {
                    return true;
                }
                bl = false;
            } while (!bl);
            return true;
        }
        ResolvedCall resolvedCall5 = resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$hasSuspendCalls), (BindingContext)this.getBindingContext());
        Object object = resolvedCall5 != null ? resolvedCall5.getResultingDescriptor() : null;
        if (!(object instanceof FunctionDescriptor)) {
            object = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)object;
        if (functionDescriptor != null) {
            if (functionDescriptor.isSuspend()) {
                return true;
            }
        }
        ResolvedCall resolvedCall6 = resolvedCall;
        Object object4 = resolvedCall6 != null ? resolvedCall6.getResultingDescriptor() : null;
        if (!(object4 instanceof PropertyDescriptor)) {
            object4 = null;
        }
        PropertyDescriptor propertyDescriptor3 = propertyDescriptor = (PropertyDescriptor)object4;
        propertyDescriptor3 = propertyDescriptor3;
        if (propertyDescriptor2 == null) return false;
        FqName fqName = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)propertyDescriptor3));
        propertyDescriptor3 = fqName;
        if (fqName == null) return false;
        String string2 = propertyDescriptor3.asString();
        string2 = s = string2;
        if (string2 == null) return false;
        if (!StringsKt.startsWith$default((String)string2, (String)"kotlin.coroutines.", (boolean)false, (int)2, null)) return false;
        if (!StringsKt.endsWith$default((String)s, (String)".coroutineContext", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public RedundantSuspendModifier(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("RedundantSuspendModifier", Severity.Minor, "`suspend` modifier is only needed for functions that contain suspending calls", Debt.Companion.getFIVE_MINS());
    }

    public static final /* synthetic */ boolean access$hasSuspendCalls(RedundantSuspendModifier $this, KtExpression $this$access_u24hasSuspendCalls) {
        return $this.hasSuspendCalls($this$access_u24hasSuspendCalls);
    }
}

