/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.exceptions;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/RethrowCaughtException;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCatchSection", "", "catchClause", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "detekt-rules"})
public final class RethrowCaughtException
extends Rule {
    @NotNull
    private final Issue issue;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitCatchSection(@NotNull KtCatchClause catchClause) {
        KtThrowExpression throwExpression2;
        Intrinsics.checkParameterIsNotNull((Object)catchClause, (String)"catchClause");
        Object object = catchClause.getCatchParameter();
        if (object == null || (object = object.getName()) == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"catchClause.catchParameter?.name ?: return");
        Object exceptionName = object;
        Object[] objectArray = catchClause.getCatchBody();
        if (objectArray == null || (objectArray = objectArray.getChildren()) == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"catchClause.catchBody?.children ?: return");
        Object[] statements = objectArray;
        Object object2 = ArraysKt.firstOrNull((Object[])statements);
        if (!(object2 instanceof KtThrowExpression)) {
            object2 = null;
        }
        if ((throwExpression2 = (KtThrowExpression)object2) != null) {
            KtExpression ktExpression = throwExpression2.getThrownExpression();
            if (Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)exceptionName)) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)throwExpression2), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
            }
        }
        super.visitCatchSection(catchClause);
    }

    public RethrowCaughtException(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("RethrowCaughtException", Severity.CodeSmell, "Do not rethrow a caught exception of the same type.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ RethrowCaughtException(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public RethrowCaughtException() {
        this(null, 1, null);
    }
}

