/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.LazyRegex;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.IdentifierNameKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/EnumNaming;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "enumEntryPattern", "Lkotlin/text/Regex;", "getEnumEntryPattern", "()Lkotlin/text/Regex;", "enumEntryPattern$delegate", "Lio/gitlab/arturbosch/detekt/api/LazyRegex;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitEnumEntry", "", "enumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "Companion", "detekt-rules"})
public final class EnumNaming
extends Rule {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    private final LazyRegex enumEntryPattern$delegate;
    @NotNull
    public static final String ENUM_PATTERN = "enumEntryPattern";
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(EnumNaming.class), ENUM_PATTERN, "getEnumEntryPattern()Lkotlin/text/Regex;"))};
        Companion = new Companion(null);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Regex getEnumEntryPattern() {
        return this.enumEntryPattern$delegate.getValue((Rule)this, $$delegatedProperties[0]);
    }

    public void visitEnumEntry(@NotNull KtEnumEntry enumEntry) {
        Intrinsics.checkParameterIsNotNull((Object)enumEntry, (String)"enumEntry");
        CharSequence charSequence = IdentifierNameKt.identifierName((KtNamedDeclaration)enumEntry);
        Regex regex = this.getEnumEntryPattern();
        boolean bl = false;
        if (!regex.matches(charSequence)) {
            Issue issue = this.getIssue();
            PsiElement psiElement = enumEntry.getNameIdentifier();
            if (psiElement == null) {
                psiElement = (PsiElement)enumEntry;
            }
            this.report((Finding)new CodeSmell(issue, Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)psiElement, (int)0, (int)2, null), "Enum entry names should match the pattern: " + this.getEnumEntryPattern(), null, null, 24, null));
        }
    }

    public EnumNaming(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Enum names should follow the naming convention set in the projects configuration.", Debt.Companion.getFIVE_MINS());
        this.enumEntryPattern$delegate = new LazyRegex(ENUM_PATTERN, "[A-Z][_a-zA-Z0-9]*");
    }

    public /* synthetic */ EnumNaming(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public EnumNaming() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/EnumNaming$Companion;", "", "()V", "ENUM_PATTERN", "", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

