/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.MultiRule;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.rules.naming.ClassNaming;
import io.gitlab.arturbosch.detekt.rules.naming.ConstructorParameterNaming;
import io.gitlab.arturbosch.detekt.rules.naming.EnumNaming;
import io.gitlab.arturbosch.detekt.rules.naming.ForbiddenClassName;
import io.gitlab.arturbosch.detekt.rules.naming.FunctionMaxLength;
import io.gitlab.arturbosch.detekt.rules.naming.FunctionMinLength;
import io.gitlab.arturbosch.detekt.rules.naming.FunctionNaming;
import io.gitlab.arturbosch.detekt.rules.naming.FunctionParameterNaming;
import io.gitlab.arturbosch.detekt.rules.naming.ObjectPropertyNaming;
import io.gitlab.arturbosch.detekt.rules.naming.PackageNaming;
import io.gitlab.arturbosch.detekt.rules.naming.TopLevelPropertyNaming;
import io.gitlab.arturbosch.detekt.rules.naming.VariableMaxLength;
import io.gitlab.arturbosch.detekt.rules.naming.VariableMinLength;
import io.gitlab.arturbosch.detekt.rules.naming.VariableNaming;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020'2\u0006\u0010(\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020'2\u0006\u0010(\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020'2\u0006\u0010(\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020'2\u0006\u0010(\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020'2\u0006\u00103\u001a\u000204H\u0016J\f\u00105\u001a\u000206*\u000207H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/NamingRules;", "Lio/gitlab/arturbosch/detekt/api/MultiRule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "classOrObjectNamingRule", "Lio/gitlab/arturbosch/detekt/rules/naming/ClassNaming;", "constructorParameterNamingRule", "Lio/gitlab/arturbosch/detekt/rules/naming/ConstructorParameterNaming;", "enumEntryNamingRule", "Lio/gitlab/arturbosch/detekt/rules/naming/EnumNaming;", "forbiddenClassNameRule", "Lio/gitlab/arturbosch/detekt/rules/naming/ForbiddenClassName;", "functionMaxNameLengthRule", "Lio/gitlab/arturbosch/detekt/rules/naming/FunctionMaxLength;", "functionMinNameLengthRule", "Lio/gitlab/arturbosch/detekt/rules/naming/FunctionMinLength;", "functionNamingRule", "Lio/gitlab/arturbosch/detekt/rules/naming/FunctionNaming;", "functionParameterNamingRule", "Lio/gitlab/arturbosch/detekt/rules/naming/FunctionParameterNaming;", "objectConstantNamingRule", "Lio/gitlab/arturbosch/detekt/rules/naming/ObjectPropertyNaming;", "packageNamingRule", "Lio/gitlab/arturbosch/detekt/rules/naming/PackageNaming;", "rules", "", "Lio/gitlab/arturbosch/detekt/api/Rule;", "getRules", "()Ljava/util/List;", "topLevelPropertyRule", "Lio/gitlab/arturbosch/detekt/rules/naming/TopLevelPropertyNaming;", "variableMaxNameLengthRule", "Lio/gitlab/arturbosch/detekt/rules/naming/VariableMaxLength;", "variableMinNameLengthRule", "Lio/gitlab/arturbosch/detekt/rules/naming/VariableMinLength;", "variableNamingRule", "Lio/gitlab/arturbosch/detekt/rules/naming/VariableNaming;", "handleClassOrObject", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "handleFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "handleParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "handleProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitNamedDeclaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitPackageDirective", "directive", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "withinObjectDeclaration", "", "Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;", "detekt-rules"})
public final class NamingRules
extends MultiRule {
    private final VariableNaming variableNamingRule;
    private final VariableMinLength variableMinNameLengthRule;
    private final VariableMaxLength variableMaxNameLengthRule;
    private final TopLevelPropertyNaming topLevelPropertyRule;
    private final ObjectPropertyNaming objectConstantNamingRule;
    private final PackageNaming packageNamingRule;
    private final ClassNaming classOrObjectNamingRule;
    private final EnumNaming enumEntryNamingRule;
    private final FunctionNaming functionNamingRule;
    private final FunctionMaxLength functionMaxNameLengthRule;
    private final FunctionMinLength functionMinNameLengthRule;
    private final ForbiddenClassName forbiddenClassNameRule;
    private final ConstructorParameterNaming constructorParameterNamingRule;
    private final FunctionParameterNaming functionParameterNamingRule;
    @NotNull
    private final List<Rule> rules;

    @NotNull
    public List<Rule> getRules() {
        return this.rules;
    }

    public void visitPackageDirective(@NotNull KtPackageDirective directive) {
        Intrinsics.checkParameterIsNotNull((Object)directive, (String)"directive");
        super.visitPackageDirective(directive);
        this.runIfActive(this.packageNamingRule, (Function1)new Function1<PackageNaming, Unit>(directive){
            final /* synthetic */ KtPackageDirective $directive;

            public final void invoke(@NotNull PackageNaming $this$runIfActive) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$this$runIfActive), (String)"$receiver");
                $this$runIfActive.visitPackageDirective(this.$directive);
            }
            {
                this.$directive = ktPackageDirective;
                super(1);
            }
        });
    }

    public void visitNamedDeclaration(@NotNull KtNamedDeclaration declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Name name = declaration.getNameAsSafeName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"declaration.nameAsSafeName");
        if (name.isSpecial()) {
            return;
        }
        Object object = declaration.getNameIdentifier();
        if (object != null && (object = object.getParent()) != null && (object = object.getClass()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            KtNamedDeclaration ktNamedDeclaration = declaration;
            if (ktNamedDeclaration instanceof KtProperty) {
                this.handleProperty((KtProperty)declaration);
            } else if (ktNamedDeclaration instanceof KtNamedFunction) {
                this.handleFunction((KtNamedFunction)declaration);
            } else if (ktNamedDeclaration instanceof KtEnumEntry) {
                this.runIfActive(this.enumEntryNamingRule, (Function1)new Function1<EnumNaming, Unit>(this, declaration){
                    final /* synthetic */ NamingRules this$0;
                    final /* synthetic */ KtNamedDeclaration $declaration$inlined;
                    {
                        this.this$0 = namingRules;
                        this.$declaration$inlined = ktNamedDeclaration;
                        super(1);
                    }

                    public final void invoke(@NotNull EnumNaming $this$runIfActive) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$runIfActive), (String)"$receiver");
                        $this$runIfActive.visitEnumEntry((KtEnumEntry)this.$declaration$inlined);
                    }
                });
            } else if (ktNamedDeclaration instanceof KtClassOrObject) {
                this.handleClassOrObject((KtClassOrObject)declaration);
            } else if (ktNamedDeclaration instanceof KtParameter) {
                this.handleParameter((KtParameter)declaration);
            }
        }
        super.visitNamedDeclaration(declaration);
    }

    private final void handleClassOrObject(KtClassOrObject declaration) {
        this.runIfActive(this.classOrObjectNamingRule, (Function1)new Function1<ClassNaming, Unit>(declaration){
            final /* synthetic */ KtClassOrObject $declaration;

            public final void invoke(@NotNull ClassNaming $this$runIfActive) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$this$runIfActive), (String)"$receiver");
                $this$runIfActive.visitClassOrObject(this.$declaration);
            }
            {
                this.$declaration = ktClassOrObject;
                super(1);
            }
        });
        this.runIfActive(this.forbiddenClassNameRule, (Function1)new Function1<ForbiddenClassName, Unit>(declaration){
            final /* synthetic */ KtClassOrObject $declaration;

            public final void invoke(@NotNull ForbiddenClassName $this$runIfActive) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$this$runIfActive), (String)"$receiver");
                $this$runIfActive.visitClassOrObject(this.$declaration);
            }
            {
                this.$declaration = ktClassOrObject;
                super(1);
            }
        });
    }

    private final void handleFunction(KtNamedFunction declaration) {
        this.runIfActive(this.functionNamingRule, (Function1)new Function1<FunctionNaming, Unit>(declaration){
            final /* synthetic */ KtNamedFunction $declaration;

            public final void invoke(@NotNull FunctionNaming $this$runIfActive) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$this$runIfActive), (String)"$receiver");
                $this$runIfActive.visitNamedFunction(this.$declaration);
            }
            {
                this.$declaration = ktNamedFunction;
                super(1);
            }
        });
        this.runIfActive(this.functionMaxNameLengthRule, (Function1)new Function1<FunctionMaxLength, Unit>(declaration){
            final /* synthetic */ KtNamedFunction $declaration;

            public final void invoke(@NotNull FunctionMaxLength $this$runIfActive) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$this$runIfActive), (String)"$receiver");
                $this$runIfActive.visitNamedFunction(this.$declaration);
            }
            {
                this.$declaration = ktNamedFunction;
                super(1);
            }
        });
        this.runIfActive(this.functionMinNameLengthRule, (Function1)new Function1<FunctionMinLength, Unit>(declaration){
            final /* synthetic */ KtNamedFunction $declaration;

            public final void invoke(@NotNull FunctionMinLength $this$runIfActive) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$this$runIfActive), (String)"$receiver");
                $this$runIfActive.visitNamedFunction(this.$declaration);
            }
            {
                this.$declaration = ktNamedFunction;
                super(1);
            }
        });
    }

    private final void handleProperty(KtProperty declaration) {
        this.runIfActive(this.variableMaxNameLengthRule, (Function1)new Function1<VariableMaxLength, Unit>(declaration){
            final /* synthetic */ KtProperty $declaration;

            public final void invoke(@NotNull VariableMaxLength $this$runIfActive) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$this$runIfActive), (String)"$receiver");
                $this$runIfActive.visitProperty(this.$declaration);
            }
            {
                this.$declaration = ktProperty;
                super(1);
            }
        });
        this.runIfActive(this.variableMinNameLengthRule, (Function1)new Function1<VariableMinLength, Unit>(declaration){
            final /* synthetic */ KtProperty $declaration;

            public final void invoke(@NotNull VariableMinLength $this$runIfActive) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$this$runIfActive), (String)"$receiver");
                $this$runIfActive.visitProperty(this.$declaration);
            }
            {
                this.$declaration = ktProperty;
                super(1);
            }
        });
        if (declaration.isTopLevel()) {
            this.runIfActive(this.topLevelPropertyRule, (Function1)new Function1<TopLevelPropertyNaming, Unit>(declaration){
                final /* synthetic */ KtProperty $declaration;

                public final void invoke(@NotNull TopLevelPropertyNaming $this$runIfActive) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)$this$runIfActive), (String)"$receiver");
                    $this$runIfActive.visitProperty(this.$declaration);
                }
                {
                    this.$declaration = ktProperty;
                    super(1);
                }
            });
        } else if (this.withinObjectDeclaration((KtVariableDeclaration)declaration)) {
            this.runIfActive(this.objectConstantNamingRule, (Function1)new Function1<ObjectPropertyNaming, Unit>(declaration){
                final /* synthetic */ KtProperty $declaration;

                public final void invoke(@NotNull ObjectPropertyNaming $this$runIfActive) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)$this$runIfActive), (String)"$receiver");
                    $this$runIfActive.visitProperty(this.$declaration);
                }
                {
                    this.$declaration = ktProperty;
                    super(1);
                }
            });
        } else {
            this.runIfActive(this.variableNamingRule, (Function1)new Function1<VariableNaming, Unit>(declaration){
                final /* synthetic */ KtProperty $declaration;

                public final void invoke(@NotNull VariableNaming $this$runIfActive) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)$this$runIfActive), (String)"$receiver");
                    $this$runIfActive.visitProperty(this.$declaration);
                }
                {
                    this.$declaration = ktProperty;
                    super(1);
                }
            });
        }
    }

    private final void handleParameter(KtParameter declaration) {
        block1: {
            KtDeclarationWithBody ktDeclarationWithBody;
            block0: {
                ktDeclarationWithBody = declaration.getOwnerFunction();
                if (!(ktDeclarationWithBody instanceof KtConstructor)) break block0;
                this.runIfActive(this.constructorParameterNamingRule, (Function1)new Function1<ConstructorParameterNaming, Unit>(declaration){
                    final /* synthetic */ KtParameter $declaration;

                    public final void invoke(@NotNull ConstructorParameterNaming $this$runIfActive) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$runIfActive), (String)"$receiver");
                        $this$runIfActive.visitParameter(this.$declaration);
                    }
                    {
                        this.$declaration = ktParameter;
                        super(1);
                    }
                });
                break block1;
            }
            if (!(ktDeclarationWithBody instanceof KtNamedFunction)) break block1;
            this.runIfActive(this.functionParameterNamingRule, (Function1)new Function1<FunctionParameterNaming, Unit>(declaration){
                final /* synthetic */ KtParameter $declaration;

                public final void invoke(@NotNull FunctionParameterNaming $this$runIfActive) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)$this$runIfActive), (String)"$receiver");
                    $this$runIfActive.visitParameter(this.$declaration);
                }
                {
                    this.$declaration = ktParameter;
                    super(1);
                }
            });
        }
    }

    private final boolean withinObjectDeclaration(@NotNull KtVariableDeclaration $this$withinObjectDeclaration) {
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)$this$withinObjectDeclaration;
        boolean $i$f$getNonStrictParentOfType = false;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtObjectDeclaration.class, (boolean)false) != null;
    }

    public NamingRules(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.variableNamingRule = new VariableNaming(config);
        this.variableMinNameLengthRule = new VariableMinLength(config);
        this.variableMaxNameLengthRule = new VariableMaxLength(config);
        this.topLevelPropertyRule = new TopLevelPropertyNaming(config);
        this.objectConstantNamingRule = new ObjectPropertyNaming(config);
        this.packageNamingRule = new PackageNaming(config);
        this.classOrObjectNamingRule = new ClassNaming(config);
        this.enumEntryNamingRule = new EnumNaming(config);
        this.functionNamingRule = new FunctionNaming(config);
        this.functionMaxNameLengthRule = new FunctionMaxLength(config);
        this.functionMinNameLengthRule = new FunctionMinLength(config);
        this.forbiddenClassNameRule = new ForbiddenClassName(config);
        this.constructorParameterNamingRule = new ConstructorParameterNaming(config);
        this.functionParameterNamingRule = new FunctionParameterNaming(config);
        this.rules = CollectionsKt.listOf((Object[])new Rule[]{this.variableNamingRule, this.variableMinNameLengthRule, this.variableMaxNameLengthRule, this.topLevelPropertyRule, this.objectConstantNamingRule, this.packageNamingRule, this.classOrObjectNamingRule, this.enumEntryNamingRule, this.functionNamingRule, this.functionMaxNameLengthRule, this.functionMinNameLengthRule, this.forbiddenClassNameRule, this.constructorParameterNamingRule, this.functionParameterNamingRule});
    }

    public /* synthetic */ NamingRules(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public NamingRules() {
        this(null, 1, null);
    }
}

