/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.style.ThrowsCount$visitNamedFunction$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtThrowExpression;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\f\u0010\u0011\u001a\u00020\u0006*\u00020\u0012H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ThrowsCount;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "excludeGuardClauses", "", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "max", "", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isGuardClause", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "Companion", "detekt-rules"})
public final class ThrowsCount
extends Rule {
    @NotNull
    private final Issue issue;
    private final int max;
    private final boolean excludeGuardClauses;
    @NotNull
    public static final String MAX = "max";
    @NotNull
    public static final String EXCLUDE_GUARD_CLAUSES = "excludeGuardClauses";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        super.visitNamedFunction(function);
        if (!KtModifierListKt.isOverride((KtModifierListOwner)function)) {
            void $this$filterNotTo$iv$iv;
            void $this$forEachDescendantOfType$iv$iv$iv;
            PsiElement $this$collectDescendantsOfType$iv = (PsiElement)function;
            Function1 predicate$iv = visitNamedFunction$$inlined$collectDescendantsOfType$1.INSTANCE;
            boolean $i$f$collectDescendantsOfType22 = false;
            PsiElement $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
            boolean $i$f$collectDescendantsOfType = false;
            ArrayList result$iv$iv = new ArrayList();
            PsiElement psiElement = $this$collectDescendantsOfType$iv$iv;
            Function1 action$iv$iv$iv = (Function1)new Function1<KtThrowExpression, Unit>(predicate$iv, result$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ ArrayList $result;
                {
                    this.$predicate = function1;
                    this.$result = arrayList;
                    super(1);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final void invoke(@NotNull PsiElement it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                        this.$result.add(it);
                    }
                }
            };
            boolean $i$f$forEachDescendantOfType = false;
            $this$forEachDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $captured_local_variable$1;
                }

                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                    if (element instanceof KtThrowExpression) {
                        this.$action.invoke((Object)element);
                    }
                }
            });
            Iterable $this$filterNot$iv = result$iv$iv;
            boolean $i$f$filterNot = false;
            Iterable $i$f$collectDescendantsOfType22 = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                KtThrowExpression it = (KtThrowExpression)element$iv$iv;
                boolean bl = false;
                if (this.excludeGuardClauses && this.isGuardClause(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection collection = (List)destination$iv$iv;
            boolean bl = false;
            int count = collection.size();
            if (count > this.max) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)function), "Too many throw statements in the function" + ' ' + function.getNameAsSafeName() + ". The maximum number of allowed throw statements is " + this.max + '.', null, null, 24, null));
            }
        }
    }

    private final boolean isGuardClause(@NotNull KtThrowExpression $this$isGuardClause) {
        PsiElement psiElement = $this$isGuardClause.getParent();
        if (!(psiElement instanceof KtBinaryExpression)) {
            psiElement = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)psiElement;
        return Intrinsics.areEqual((Object)(ktBinaryExpression != null ? ktBinaryExpression.getOperationToken() : null), (Object)KtTokens.ELVIS);
    }

    public ThrowsCount(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Restrict the number of throw statements in methods.", Debt.Companion.getTEN_MINS());
        this.max = ((Number)this.valueOrDefault(MAX, 2)).intValue();
        this.excludeGuardClauses = (Boolean)this.valueOrDefault(EXCLUDE_GUARD_CLAUSES, false);
    }

    public /* synthetic */ ThrowsCount(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public ThrowsCount() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ThrowsCount$Companion;", "", "()V", "EXCLUDE_GUARD_CLAUSES", "", "MAX", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

