/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.style.UnusedPrivateClass;
import io.gitlab.arturbosch.detekt.rules.style.UnusedPrivateClassKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtDoubleColonExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnusedPrivateClass;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "defaultRuleIdAliases", "", "", "getDefaultRuleIdAliases", "()Ljava/util/Set;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visit", "", "root", "Lorg/jetbrains/kotlin/psi/KtFile;", "UnusedClassVisitor", "detekt-rules"})
public final class UnusedPrivateClass
extends Rule {
    @NotNull
    private final Set<String> defaultRuleIdAliases;
    @NotNull
    private final Issue issue;

    @NotNull
    public Set<String> getDefaultRuleIdAliases() {
        return this.defaultRuleIdAliases;
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visit(@NotNull KtFile root) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        super.visit(root);
        UnusedClassVisitor classVisitor = new UnusedClassVisitor();
        root.accept((PsiElementVisitor)classVisitor);
        Iterable $this$forEach$iv = classVisitor.getUnusedClasses();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtNamedDeclaration it = (KtNamedDeclaration)element$iv;
            boolean bl = false;
            Issue issue = this.getIssue();
            Entity entity = Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it), (int)0, (int)2, null);
            StringBuilder stringBuilder = new StringBuilder().append("Private class ");
            Name name = it.getNameAsSafeName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"it.nameAsSafeName");
            this.report((Finding)new CodeSmell(issue, entity, stringBuilder.append(name.getIdentifier()).append(" is unused.").toString(), null, null, 24, null));
        }
    }

    public UnusedPrivateClass(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        this.defaultRuleIdAliases = SetsKt.setOf((Object)"unused");
        this.issue = new Issue("UnusedPrivateClass", Severity.Maintainability, "Private class is unused.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UnusedPrivateClass(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public UnusedPrivateClass() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u000b2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u000b2\u0006\u00103\u001a\u000204H\u0016J\f\u00105\u001a\u00020\u0011*\u00020\tH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnusedPrivateClass$UnusedClassVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "()V", "importedFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "namedClasses", "", "privateClasses", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "checkReceiverForClassUsage", "", "receiver", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getUnusedClasses", "", "looksLikeAClassName", "", "maybeClassName", "registerAccess", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "visitAnnotationEntry", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "visitCallExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitDotQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "visitDoubleColonExpression", "Lorg/jetbrains/kotlin/psi/KtDoubleColonExpression;", "visitFunctionType", "type", "Lorg/jetbrains/kotlin/psi/KtFunctionType;", "visitImportDirective", "importDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "isUsed", "detekt-rules"})
    private static final class UnusedClassVisitor
    extends DetektVisitor {
        private final Set<KtNamedDeclaration> privateClasses;
        private final Set<String> namedClasses;
        private final Set<FqName> importedFqNames;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<KtNamedDeclaration> getUnusedClasses() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.privateClasses;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtNamedDeclaration it = (KtNamedDeclaration)element$iv$iv;
                boolean bl = false;
                if (!(!this.isUsed(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isUsed(@NotNull KtNamedDeclaration $this$isUsed) {
            boolean bl;
            Name name = $this$isUsed.getNameAsSafeName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"nameAsSafeName");
            if (this.namedClasses.contains(name.getIdentifier())) {
                return true;
            }
            FqName fqName = $this$isUsed.getFqName();
            Collection collection = fqName != null ? fqName.pathSegments() : null;
            boolean bl2 = false;
            Collection collection2 = collection;
            if (collection2 == null) {
                collection2 = kotlin.collections.CollectionsKt.emptyList();
            }
            List pathSegments = collection2;
            collection = pathSegments;
            bl2 = false;
            if (collection.isEmpty()) return false;
            boolean bl3 = true;
            if (!bl3) return false;
            Iterable $this$any$iv = this.importedFqNames;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                Pair it;
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                FqName importedFqName = (FqName)element$iv;
                boolean bl4 = false;
                List list = importedFqName.pathSegments();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"importedFqName.pathSegments()");
                Iterable $this$all$iv = kotlin.collections.CollectionsKt.zip((Iterable)list, (Iterable)pathSegments);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    return true;
                }
                Iterator iterator2 = $this$all$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return true;
                    Object element$iv2 = iterator2.next();
                    it = (Pair)element$iv2;
                    boolean bl5 = false;
                } while (Intrinsics.areEqual((Object)((Name)it.getFirst()), (Object)((Name)it.getSecond())));
                bl = false;
            } while (!bl);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public void visitClass(@NotNull KtClass klass) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)klass, (String)"klass");
            if (KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)klass))) {
                this.privateClasses.add((KtNamedDeclaration)klass);
            }
            if ((object = klass.getSuperTypeList()) != null && (object = object.getEntries()) != null) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = (Iterable)object;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    KtTypeReference ktTypeReference;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    KtSuperTypeListEntry it = (KtSuperTypeListEntry)element$iv$iv;
                    boolean bl2 = false;
                    KtSuperTypeListEntry ktSuperTypeListEntry = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktSuperTypeListEntry, (String)"it");
                    if (ktSuperTypeListEntry.getTypeReference() == null) continue;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    KtTypeReference it$iv$iv = ktTypeReference;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtTypeReference it = (KtTypeReference)element$iv;
                    boolean bl = false;
                    KtTypeReference ktTypeReference = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference, (String)"it");
                    this.registerAccess(ktTypeReference);
                }
            }
            super.visitClass(klass);
        }

        public void visitImportDirective(@NotNull KtImportDirective importDirective) {
            Intrinsics.checkParameterIsNotNull((Object)importDirective, (String)"importDirective");
            CollectionsKt.addIfNotNull((Collection)this.importedFqNames, (Object)importDirective.getImportedFqName());
            super.visitImportDirective(importDirective);
        }

        public void visitAnnotationEntry(@NotNull KtAnnotationEntry annotationEntry) {
            Intrinsics.checkParameterIsNotNull((Object)annotationEntry, (String)"annotationEntry");
            KtTypeReference ktTypeReference = annotationEntry.getTypeReference();
            CollectionsKt.addIfNotNull((Collection)this.namedClasses, (Object)(ktTypeReference != null ? ktTypeReference.getText() : null));
            super.visitAnnotationEntry(annotationEntry);
        }

        private final void registerAccess(KtTypeReference typeReference) {
            Object object;
            Object object2;
            KtElement ktElement = UnusedPrivateClassKt.access$orInnerType(typeReference);
            boolean bl = false;
            boolean bl2 = false;
            KtElement $this$run = ktElement;
            boolean bl3 = false;
            String string = $this$run.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
            this.namedClasses.add(string);
            KtTypeElement ktTypeElement = typeReference.getTypeElement();
            Object object3 = ktTypeElement != null ? UnusedPrivateClassKt.access$orInnerType(ktTypeElement) : null;
            if (!(object3 instanceof KtUserType)) {
                object3 = null;
            }
            if ((object2 = (KtUserType)object3) != null && (object2 = object2.getReferencedName()) != null) {
                ktElement = object2;
                bl = false;
                bl2 = false;
                $this$run = ktElement;
                boolean bl4 = false;
                KtElement ktElement2 = $this$run;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktElement2, (String)"this");
                this.namedClasses.add((String)ktElement2);
            }
            if ((object = typeReference.getTypeElement()) != null && (object = object.getTypeArgumentsAsTypes()) != null && (object = kotlin.collections.CollectionsKt.asSequence((Iterable)((Iterable)object))) != null && (object = SequencesKt.filterNotNull((Sequence)object)) != null && (object = SequencesKt.map((Sequence)object, (Function1)registerAccess.3.INSTANCE)) != null) {
                Object $this$forEach$iv = object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtElement it = (KtElement)element$iv;
                    boolean bl5 = false;
                    String string2 = it.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.text");
                    this.namedClasses.add(string2);
                    if (!(it instanceof KtTypeReference)) continue;
                    this.registerAccess((KtTypeReference)it);
                }
            }
        }

        public void visitParameter(@NotNull KtParameter parameter) {
            Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
            KtTypeReference ktTypeReference = parameter.getTypeReference();
            if (ktTypeReference != null) {
                KtTypeReference ktTypeReference2 = ktTypeReference;
                boolean bl = false;
                boolean bl2 = false;
                KtTypeReference $this$run = ktTypeReference2;
                boolean bl3 = false;
                KtTypeReference ktTypeReference3 = $this$run;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference3, (String)"this");
                this.registerAccess(ktTypeReference3);
            }
            super.visitParameter(parameter);
        }

        public void visitNamedFunction(@NotNull KtNamedFunction function) {
            Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
            KtTypeReference ktTypeReference = function.getTypeReference();
            if (ktTypeReference != null) {
                KtTypeReference ktTypeReference2 = ktTypeReference;
                boolean bl = false;
                boolean bl2 = false;
                KtTypeReference $this$run = ktTypeReference2;
                boolean bl3 = false;
                KtTypeReference ktTypeReference3 = $this$run;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference3, (String)"this");
                this.registerAccess(ktTypeReference3);
            }
            super.visitNamedFunction(function);
        }

        public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Object object = declaration.getSuperTypeList();
            if (object != null && (object = object.getEntries()) != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtSuperTypeListEntry it = (KtSuperTypeListEntry)element$iv;
                    boolean bl = false;
                    KtSuperTypeListEntry ktSuperTypeListEntry = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktSuperTypeListEntry, (String)"it");
                    if (ktSuperTypeListEntry.getTypeReference() != null) {
                        KtTypeReference ktTypeReference;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        KtTypeReference $this$run = ktTypeReference;
                        boolean bl4 = false;
                        KtTypeReference ktTypeReference2 = $this$run;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference2, (String)"this");
                        this.registerAccess(ktTypeReference2);
                    }
                }
            }
            super.visitObjectDeclaration(declaration);
        }

        public void visitFunctionType(@NotNull KtFunctionType type) {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            KtTypeReference ktTypeReference = type.getReturnTypeReference();
            if (ktTypeReference != null) {
                KtTypeReference ktTypeReference2 = ktTypeReference;
                boolean bl = false;
                boolean bl2 = false;
                KtTypeReference $this$run = ktTypeReference2;
                boolean bl3 = false;
                KtTypeReference ktTypeReference3 = $this$run;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference3, (String)"this");
                this.registerAccess(ktTypeReference3);
            }
            super.visitFunctionType(type);
        }

        public void visitProperty(@NotNull KtProperty property) {
            Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
            KtTypeReference ktTypeReference = property.getTypeReference();
            if (ktTypeReference != null) {
                KtTypeReference ktTypeReference2 = ktTypeReference;
                boolean bl = false;
                boolean bl2 = false;
                KtTypeReference $this$run = ktTypeReference2;
                boolean bl3 = false;
                KtTypeReference ktTypeReference3 = $this$run;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference3, (String)"this");
                this.registerAccess(ktTypeReference3);
            }
            super.visitProperty(property);
        }

        /*
         * WARNING - void declaration
         */
        public void visitCallExpression(@NotNull KtCallExpression expression) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
            Object object = expression.getCalleeExpression();
            if (object != null && (object = object.getText()) != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object $this$run = object2;
                boolean bl3 = false;
                this.namedClasses.add((String)$this$run);
            }
            List list = expression.getTypeArguments();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"expression.typeArguments");
            Iterable $this$mapNotNull$iv = list;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                KtTypeReference ktTypeReference;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                KtTypeProjection it = (KtTypeProjection)element$iv$iv;
                boolean bl4 = false;
                KtTypeProjection ktTypeProjection = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeProjection, (String)"it");
                if (ktTypeProjection.getTypeReference() == null) continue;
                boolean bl5 = false;
                boolean bl6 = false;
                KtTypeReference it$iv$iv = ktTypeReference;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                KtTypeReference it = (KtTypeReference)element$iv;
                boolean bl = false;
                KtTypeReference ktTypeReference = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference, (String)"it");
                this.registerAccess(ktTypeReference);
            }
            super.visitCallExpression(expression);
        }

        public void visitDoubleColonExpression(@NotNull KtDoubleColonExpression expression) {
            Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
            this.checkReceiverForClassUsage(expression.getReceiverExpression());
            if (expression.isEmptyLHS()) {
                Object object;
                KtDoubleColonExpression $this$safeAs$iv = expression;
                boolean $i$f$safeAs = false;
                KtDoubleColonExpression ktDoubleColonExpression = $this$safeAs$iv;
                if (!(ktDoubleColonExpression instanceof KtCallableReferenceExpression)) {
                    ktDoubleColonExpression = null;
                }
                if ((object = (KtCallableReferenceExpression)ktDoubleColonExpression) != null && (object = object.getCallableReference()) != null) {
                    KtCallableReferenceExpression ktCallableReferenceExpression = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    KtCallableReferenceExpression it = ktCallableReferenceExpression;
                    boolean bl3 = false;
                    object = this.looksLikeAClassName(it.getReferencedName()) ? ktCallableReferenceExpression : null;
                    if (object != null) {
                        ktCallableReferenceExpression = object;
                        bl = false;
                        bl2 = false;
                        it = ktCallableReferenceExpression;
                        boolean bl4 = false;
                        this.namedClasses.add(it.getReferencedName());
                    }
                }
            }
            super.visitDoubleColonExpression(expression);
        }

        private final void checkReceiverForClassUsage(KtExpression receiver) {
            block2: {
                Object object;
                KtExpression ktExpression = receiver;
                if (!(ktExpression instanceof KtNameReferenceExpression)) {
                    ktExpression = null;
                }
                if ((object = (KtNameReferenceExpression)ktExpression) == null || (object = object.getText()) == null) break block2;
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                object = this.looksLikeAClassName((String)it) ? object2 : null;
                if (object != null) {
                    object2 = object;
                    bl = false;
                    bl2 = false;
                    it = object2;
                    boolean bl4 = false;
                    this.namedClasses.add((String)it);
                }
            }
        }

        public void visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression) {
            Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
            this.checkReceiverForClassUsage(expression.getReceiverExpression());
            super.visitDotQualifiedExpression(expression);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean looksLikeAClassName(String maybeClassName) {
            Character c = StringsKt.firstOrNull((CharSequence)maybeClassName);
            if (c == null) return false;
            char c2 = c.charValue();
            boolean bl = false;
            if (!Character.isUpperCase(c2)) return false;
            return true;
        }

        public UnusedClassVisitor() {
            Set set;
            UnusedClassVisitor unusedClassVisitor = this;
            boolean bl = false;
            unusedClassVisitor.privateClasses = set = (Set)new LinkedHashSet();
            unusedClassVisitor = this;
            bl = false;
            unusedClassVisitor.namedClasses = set = (Set)new LinkedHashSet();
            unusedClassVisitor = this;
            bl = false;
            unusedClassVisitor.importedFqNames = set = (Set)new LinkedHashSet();
        }
    }
}

