/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.AnnotationExcluder;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.JunkKt;
import io.gitlab.arturbosch.detekt.rules.KtClassOrObjectExtensionsKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\f*\u00020\u0013H\u0002J$\u0010\u001e\u001a\u00020\u0006*\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006$"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseDataClass;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "allowVars", "", "defaultFunctionNames", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "excludeAnnotatedClasses", "", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "hasOnlyPrivateConstructors", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "isIncorrectClassType", "visit", "", "root", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitKlass", "annotationExcluder", "Lio/gitlab/arturbosch/detekt/api/AnnotationExcluder;", "extractConstructorPropertyParameters", "Lorg/jetbrains/kotlin/psi/KtParameter;", "isDefaultFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "classType", "Lorg/jetbrains/kotlin/types/KotlinType;", "primaryConstructorParameterTypes", "Companion", "detekt-rules"})
public final class UseDataClass
extends Rule {
    @NotNull
    private final Issue issue;
    private final List<String> excludeAnnotatedClasses;
    private final HashSet<String> defaultFunctionNames;
    private final boolean allowVars;
    @NotNull
    public static final String ALLOW_VARS = "allowVars";
    @NotNull
    public static final String EXCLUDE_ANNOTATED_CLASSES = "excludeAnnotatedClasses";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public void visit(@NotNull KtFile root) {
        void $this$forEachDescendantOfType$iv;
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        super.visit(root);
        AnnotationExcluder annotationExcluder = new AnnotationExcluder(root, this.excludeAnnotatedClasses);
        PsiElement psiElement = (PsiElement)root;
        Function1 action$iv = (Function1)new Function1<KtClass, Unit>(this, annotationExcluder){
            final /* synthetic */ UseDataClass this$0;
            final /* synthetic */ AnnotationExcluder $annotationExcluder;

            public final void invoke(@NotNull KtClass it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                UseDataClass.access$visitKlass(this.this$0, it, this.$annotationExcluder);
            }
            {
                this.this$0 = useDataClass;
                this.$annotationExcluder = annotationExcluder;
                super(1);
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        void $this$forEachDescendantOfType$iv$iv = $this$forEachDescendantOfType$iv;
        boolean $i$f$forEachDescendantOfType2 = false;
        $this$forEachDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $captured_local_variable$1;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtClass) {
                    this.$action.invoke((Object)element);
                }
            }
        });
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void visitKlass(KtClass klass, AnnotationExcluder annotationExcluder) {
        block30: {
            block29: {
                block28: {
                    block27: {
                        block26: {
                            if (this.isIncorrectClassType(klass) || this.hasOnlyPrivateConstructors(klass)) {
                                return;
                            }
                            if (!KtClassOrObjectExtensionsKt.isClosedForExtension(klass) || !KtClassOrObjectExtensionsKt.doesNotExtendAnything(klass)) break block30;
                            v0 = klass.getAnnotationEntries();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"klass.annotationEntries");
                            if (annotationExcluder.shouldExclude(v0)) break block30;
                            declarations = KtClassOrObjectExtensionsKt.extractDeclarations(klass);
                            $this$filterIsInstance$iv = declarations;
                            $i$f$filterIsInstance = false;
                            var7_7 = $this$filterIsInstance$iv;
                            destination$iv$iv /* !! */  = new ArrayList<E>();
                            $i$f$filterIsInstanceTo = false;
                            for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                                if (!(element$iv$iv /* !! */  instanceof KtProperty)) continue;
                                destination$iv$iv /* !! */ .add(element$iv$iv /* !! */ );
                            }
                            properties = (List)destination$iv$iv /* !! */ ;
                            $this$filterIsInstance$iv = declarations;
                            $i$f$filterIsInstance = false;
                            destination$iv$iv /* !! */  = $this$filterIsInstance$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$filterIsInstanceTo = false;
                            for (E element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                                if (!(element$iv$iv instanceof KtNamedFunction)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            functions = (List)destination$iv$iv;
                            propertyParameters = this.extractConstructorPropertyParameters(klass);
                            v1 = this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)klass.getPrimaryConstructor());
                            if (!(v1 instanceof ClassConstructorDescriptor)) {
                                v1 = null;
                            }
                            if ((v2 /* !! */  = (primaryConstructor = (ClassConstructorDescriptor)v1)) != null && (v2 /* !! */  = v2 /* !! */ .getValueParameters()) != null) {
                                $this$map$iv = (Iterable)v2 /* !! */ ;
                                $i$f$map = false;
                                element$iv$iv /* !! */  = $this$map$iv;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    var16_31 = (ValueParameterDescriptor)item$iv$iv;
                                    var20_40 = destination$iv$iv;
                                    $i$a$-map-UseDataClass$visitKlass$primaryConstructorParameterTypes$1 = false;
                                    v3 = it;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                                    var21_41 = v3.getType();
                                    var20_40.add(var21_41);
                                }
                                v4 = (List)destination$iv$iv;
                            } else {
                                v4 = null;
                            }
                            $this$map$iv = v4;
                            $i$f$map = false;
                            v5 = $this$map$iv;
                            if (v5 == null) {
                                v5 = CollectionsKt.emptyList();
                            }
                            primaryConstructorParameterTypes = v5;
                            v6 = primaryConstructor;
                            classType = v6 != null && (v6 = v6.getContainingDeclaration()) != null ? v6.getDefaultType() : null;
                            $this$all$iv = functions;
                            $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                v7 = true;
                            } else {
                                for (T element$iv : $this$all$iv) {
                                    it = (KtNamedFunction)element$iv;
                                    $i$a$-all-UseDataClass$visitKlass$containsFunctions$1 = false;
                                    if (this.isDefaultFunction(it, (KotlinType)classType, (List<? extends KotlinType>)primaryConstructorParameterTypes)) continue;
                                    v7 = false;
                                    break block26;
                                }
                                v7 = true;
                            }
                        }
                        containsFunctions = v7;
                        $i$f$all = properties;
                        $i$f$mapTo = false;
                        if ($i$f$all.isEmpty() == false) ** GOTO lbl-1000
                        $i$f$all = propertyParameters;
                        $i$f$mapTo = false;
                        if ($i$f$all.isEmpty() == false) lbl-1000:
                        // 2 sources

                        {
                            v8 = true;
                        } else {
                            v8 = false;
                        }
                        containsPropertyOrPropertyParameters = v8;
                        $this$any$iv = properties;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            v9 = false;
                        } else {
                            for (E element$iv : $this$any$iv) {
                                it = (KtProperty)element$iv;
                                $i$a$-any-UseDataClass$visitKlass$containsVars$1 = false;
                                if (!it.isVar()) continue;
                                v9 = true;
                                break block27;
                            }
                            v9 = false;
                        }
                    }
                    if (v9) ** GOTO lbl-1000
                    $this$any$iv = propertyParameters;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v10 = false;
                    } else {
                        for (E element$iv : $this$any$iv) {
                            it = (KtParameter)element$iv;
                            $i$a$-any-UseDataClass$visitKlass$containsVars$2 = false;
                            if (!it.isMutable()) continue;
                            v10 = true;
                            break block28;
                        }
                        v10 = false;
                    }
                }
                if (v10) lbl-1000:
                // 2 sources

                {
                    v11 = true;
                } else {
                    v11 = false;
                }
                containsVars = v11;
                $this$any$iv = properties;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v12 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (KtProperty)element$iv;
                        $i$a$-any-UseDataClass$visitKlass$containsDelegatedProperty$1 = false;
                        if (!it.hasDelegate()) continue;
                        v12 = true;
                        break block29;
                    }
                    v12 = containsDelegatedProperty = false;
                }
            }
            if (containsFunctions && containsPropertyOrPropertyParameters && !containsDelegatedProperty) {
                if (this.allowVars && containsVars) {
                    return;
                }
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)klass), (int)0, (int)2, null), "The class " + klass.getNameAsSafeName() + " defines no " + "functionality and only holds data. Consider converting it to a data class.", null, null, 24, null));
            }
        }
    }

    private final boolean isIncorrectClassType(KtClass klass) {
        return klass.isData() || klass.isEnum() || klass.isAnnotation() || klass.isSealed() || KtModifierListKt.isInline((KtModifierListOwner)klass);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasOnlyPrivateConstructors(KtClass klass) {
        KtSecondaryConstructor it;
        KtPrimaryConstructor primaryConstructor = klass.getPrimaryConstructor();
        if (primaryConstructor != null) {
            if (!KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)primaryConstructor))) return false;
        }
        Iterable $this$all$iv = klass.getSecondaryConstructors();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (KtSecondaryConstructor)element$iv;
            boolean bl = false;
        } while (KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)it)));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtParameter> extractConstructorPropertyParameters(@NotNull KtClass $this$extractConstructorPropertyParameters) {
        List list;
        Object object = $this$extractConstructorPropertyParameters.getPrimaryConstructorParameterList();
        if (object != null && (object = object.getParameters()) != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)object;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtParameter it = (KtParameter)element$iv$iv;
                boolean bl = false;
                KtParameter ktParameter = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"it");
                if (!KtPsiUtilKt.isPropertyParameter((KtParameter)ktParameter)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List list2 = list;
        boolean bl = false;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDefaultFunction(@NotNull KtNamedFunction $this$isDefaultFunction, KotlinType classType, List<? extends KotlinType> primaryConstructorParameterTypes) {
        Pair it;
        Iterable iterable;
        Object object;
        boolean $i$f$map;
        Iterable $this$map$iv;
        FunctionDescriptor descriptor;
        String string = $this$isDefaultFunction.getName();
        if (!CollectionsKt.contains((Iterable)this.defaultFunctionNames, (Object)string)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)string, (Object)"copy")) return true;
        if (classType == null) return true;
        Object object2 = this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)$this$isDefaultFunction);
        if (!(object2 instanceof FunctionDescriptor)) {
            object2 = null;
        }
        FunctionDescriptor functionDescriptor = descriptor = (FunctionDescriptor)object2;
        KotlinType returnType = functionDescriptor != null ? functionDescriptor.getReturnType() : null;
        Object object3 = descriptor;
        if (object3 != null && (object3 = object3.getValueParameters()) != null) {
            void $this$mapTo$iv$iv;
            $this$map$iv = (Iterable)object3;
            $i$f$map = false;
            object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v3 = it2;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                KotlinType kotlinType = v3.getType();
                collection.add(kotlinType);
            }
            iterable = (List)destination$iv$iv;
        } else {
            iterable = null;
        }
        $this$map$iv = iterable;
        $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        if (iterable2 == null) {
            iterable2 = CollectionsKt.emptyList();
        }
        Iterable parameterTypes = iterable2;
        if (!Intrinsics.areEqual((Object)returnType, (Object)classType)) return false;
        if (parameterTypes.size() != primaryConstructorParameterTypes.size()) return false;
        Iterable $this$all$iv = CollectionsKt.zip((Iterable)parameterTypes, (Iterable)primaryConstructorParameterTypes);
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        object = $this$all$iv.iterator();
        do {
            if (!object.hasNext()) return true;
            Object element$iv = object.next();
            it = (Pair)element$iv;
            boolean bl = false;
        } while (Intrinsics.areEqual((Object)((KotlinType)it.getFirst()), (Object)((KotlinType)it.getSecond())));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public UseDataClass(@NotNull Config config) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("UseDataClass", Severity.Style, "Classes that do nothing but hold data should be replaced with a data class.", Debt.Companion.getFIVE_MINS());
        Iterable iterable = JunkKt.valueOrDefaultCommaSeparated((Config)this, EXCLUDE_ANNOTATED_CLASSES, CollectionsKt.emptyList());
        UseDataClass useDataClass = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)it, (CharSequence)"*"), (CharSequence)"*");
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        useDataClass.excludeAnnotatedClasses = collection;
        this.defaultFunctionNames = SetsKt.hashSetOf((Object[])new String[]{"hashCode", "equals", "toString", "copy"});
        this.allowVars = (Boolean)this.valueOrDefault(ALLOW_VARS, false);
    }

    public /* synthetic */ UseDataClass(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public UseDataClass() {
        this(null, 1, null);
    }

    public static final /* synthetic */ void access$visitKlass(UseDataClass $this, KtClass klass, AnnotationExcluder annotationExcluder) {
        $this.visitKlass(klass, annotationExcluder);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseDataClass$Companion;", "", "()V", "ALLOW_VARS", "", "EXCLUDE_ANNOTATED_CLASSES", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

