/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IgnoreJRERequirement;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jspecify.annotations.Nullable;

@IgnoreJRERequirement
public final class IntStreamSubject
extends Subject {
    private final @Nullable List<?> actualList;

    IntStreamSubject(FailureMetadata failureMetadata, @Nullable IntStream stream) {
        super(failureMetadata, stream);
        this.actualList = stream == null ? null : (List)stream.boxed().collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    protected String actualCustomStringRepresentation() {
        return String.valueOf(this.actualList);
    }

    @Deprecated
    public static Subject.Factory<IntStreamSubject, IntStream> intStreams() {
        return IntStreamSubject::new;
    }

    public void isEmpty() {
        this.check().that(this.actualList).isEmpty();
    }

    public void isNotEmpty() {
        this.check().that(this.actualList).isNotEmpty();
    }

    public void hasSize(int expectedSize) {
        this.check().that(this.actualList).hasSize(expectedSize);
    }

    public void contains(int element) {
        this.check().that(this.actualList).contains(element);
    }

    public void doesNotContain(int element) {
        this.check().that(this.actualList).doesNotContain(element);
    }

    public void containsNoDuplicates() {
        this.check().that(this.actualList).containsNoDuplicates();
    }

    public void containsAnyOf(int first2, int second2, int ... rest) {
        this.check().that(this.actualList).containsAnyOf(first2, second2, IntStreamSubject.box(rest));
    }

    public void containsAnyIn(@Nullable Iterable<?> expected) {
        this.check().that(this.actualList).containsAnyIn(expected);
    }

    @CanIgnoreReturnValue
    public Ordered containsAtLeast(int first2, int second2, int ... rest) {
        return this.check().that(this.actualList).containsAtLeast(first2, second2, IntStreamSubject.box(rest));
    }

    @CanIgnoreReturnValue
    public Ordered containsAtLeastElementsIn(@Nullable Iterable<?> expected) {
        return this.check().that(this.actualList).containsAtLeastElementsIn(expected);
    }

    @CanIgnoreReturnValue
    public Ordered containsExactly(int ... varargs) {
        Preconditions.checkNotNull(varargs);
        return this.check().that(this.actualList).containsExactlyElementsIn(IntStreamSubject.box(varargs));
    }

    @CanIgnoreReturnValue
    public Ordered containsExactlyElementsIn(@Nullable Iterable<?> expected) {
        return this.check().that(this.actualList).containsExactlyElementsIn(expected);
    }

    public void containsNoneOf(int first2, int second2, int ... rest) {
        this.check().that(this.actualList).containsNoneOf(first2, second2, IntStreamSubject.box(rest));
    }

    public void containsNoneIn(@Nullable Iterable<?> excluded) {
        this.check().that(this.actualList).containsNoneIn(excluded);
    }

    public void isInStrictOrder() {
        this.check().that(this.actualList).isInStrictOrder();
    }

    public void isInStrictOrder(Comparator<? super Integer> comparator) {
        this.check().that(this.actualList).isInStrictOrder(comparator);
    }

    public void isInOrder() {
        this.check().that(this.actualList).isInOrder();
    }

    public void isInOrder(Comparator<? super Integer> comparator) {
        this.check().that(this.actualList).isInOrder(comparator);
    }

    private static Object[] box(int[] rest) {
        return IntStream.of(rest).boxed().toArray(Integer[]::new);
    }
}

