/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.truth.Correspondence;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Ordered;
import com.google.common.truth.StandardSubjectBuilder;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectUtils;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public class MapSubject
extends Subject {
    private final @Nullable Map<?, ?> actual;
    private static final Ordered IN_ORDER = () -> {};
    private static final Ordered ALREADY_FAILED = () -> {};

    protected MapSubject(FailureMetadata metadata, @Nullable Map<?, ?> map2) {
        super(metadata, map2);
        this.actual = map2;
    }

    @Override
    public final void isEqualTo(@Nullable Object other) {
        if (Objects.equal(this.actual, other)) {
            return;
        }
        if (this.actual == null || !(other instanceof Map)) {
            super.isEqualTo(other);
            return;
        }
        this.containsEntriesInAnyOrder((Map)other, false);
    }

    public final void isEmpty() {
        if (!Preconditions.checkNotNull(this.actual).isEmpty()) {
            this.failWithActual(Fact.simpleFact("expected to be empty"), new Fact[0]);
        }
    }

    public final void isNotEmpty() {
        if (Preconditions.checkNotNull(this.actual).isEmpty()) {
            this.failWithoutActual(Fact.simpleFact("expected not to be empty"), new Fact[0]);
        }
    }

    public final void hasSize(int expectedSize) {
        Preconditions.checkArgument(expectedSize >= 0, "expectedSize (%s) must be >= 0", expectedSize);
        this.check("size()", new Object[0]).that(Preconditions.checkNotNull(this.actual).size()).isEqualTo(expectedSize);
    }

    public final void containsKey(@Nullable Object key) {
        this.check("keySet()", new Object[0]).that(Preconditions.checkNotNull(this.actual).keySet()).contains(key);
    }

    public final void doesNotContainKey(@Nullable Object key) {
        this.check("keySet()", new Object[0]).that(Preconditions.checkNotNull(this.actual).keySet()).doesNotContain(key);
    }

    public final void containsEntry(@Nullable Object key, @Nullable Object value) {
        Map.Entry<@Nullable Object, @Nullable Object> entry = Maps.immutableEntry(key, value);
        Preconditions.checkNotNull(this.actual);
        if (!this.actual.entrySet().contains(entry)) {
            List<@Nullable Object> keyList = Collections.singletonList(key);
            List<@Nullable Object> valueList = Collections.singletonList(value);
            if (this.actual.containsKey(key)) {
                Object actualValue = this.actual.get(key);
                StandardSubjectBuilder check = this.check("get(%s)", key);
                if (value == null || actualValue == null) {
                    check = check.withMessage("key is present but with a different value");
                }
                check.that(actualValue).failEqualityCheckForEqualsWithoutDescription(value);
            } else if (SubjectUtils.hasMatchingToStringPair(this.actual.keySet(), keyList)) {
                this.failWithoutActual(Fact.fact("expected to contain entry", entry), Fact.fact("an instance of", SubjectUtils.objectToTypeName(entry)), Fact.simpleFact("but did not"), Fact.fact("though it did contain keys", SubjectUtils.countDuplicatesAndAddTypeInfo(SubjectUtils.retainMatchingToString(this.actual.keySet(), keyList))), Fact.fact("full contents", this.actualCustomStringRepresentationForPackageMembersToCall()));
            } else if (this.actual.containsValue(value)) {
                LinkedHashSet<@Nullable ?> keys2 = new LinkedHashSet();
                for (Map.Entry<?, ?> actualEntry : this.actual.entrySet()) {
                    if (!Objects.equal(actualEntry.getValue(), value)) continue;
                    keys2.add(actualEntry.getKey());
                }
                this.failWithoutActual(Fact.fact("expected to contain entry", entry), Fact.simpleFact("but did not"), Fact.fact("though it did contain keys with that value", keys2), Fact.fact("full contents", this.actualCustomStringRepresentationForPackageMembersToCall()));
            } else if (SubjectUtils.hasMatchingToStringPair(this.actual.values(), valueList)) {
                this.failWithoutActual(Fact.fact("expected to contain entry", entry), Fact.fact("an instance of", SubjectUtils.objectToTypeName(entry)), Fact.simpleFact("but did not"), Fact.fact("though it did contain values", SubjectUtils.countDuplicatesAndAddTypeInfo(SubjectUtils.retainMatchingToString(this.actual.values(), valueList))), Fact.fact("full contents", this.actualCustomStringRepresentationForPackageMembersToCall()));
            } else {
                this.failWithActual("expected to contain entry", entry);
            }
        }
    }

    public final void doesNotContainEntry(@Nullable Object key, @Nullable Object value) {
        this.checkNoNeedToDisplayBothValues("entrySet()", new Object[0]).that(Preconditions.checkNotNull(this.actual).entrySet()).doesNotContain(Maps.immutableEntry(key, value));
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactly() {
        return this.containsExactlyEntriesIn(ImmutableMap.of());
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactly(@Nullable Object k0, @Nullable Object v0, Object ... rest) {
        return this.containsExactlyEntriesIn(MapSubject.accumulateMap("containsExactly", k0, v0, rest));
    }

    @CanIgnoreReturnValue
    public final Ordered containsAtLeast(@Nullable Object k0, @Nullable Object v0, Object ... rest) {
        return this.containsAtLeastEntriesIn(MapSubject.accumulateMap("containsAtLeast", k0, v0, rest));
    }

    private static Map<@Nullable Object, @Nullable Object> accumulateMap(String functionName, @Nullable Object k0, @Nullable Object v0, Object ... rest) {
        Preconditions.checkArgument(rest.length % 2 == 0, "There must be an equal number of key/value pairs (i.e., the number of key/value parameters (%s) must be even).", rest.length + 2);
        LinkedHashMap<@Nullable Object, @Nullable Object> expectedMap = Maps.newLinkedHashMap();
        expectedMap.put(k0, v0);
        LinkedHashMultiset<@Nullable Object> keys2 = LinkedHashMultiset.create();
        keys2.add(k0);
        for (int i = 0; i < rest.length; i += 2) {
            Object key = rest[i];
            expectedMap.put(key, rest[i + 1]);
            keys2.add(key);
        }
        Preconditions.checkArgument(keys2.size() == expectedMap.size(), "Duplicate keys (%s) cannot be passed to %s().", keys2, (Object)functionName);
        return expectedMap;
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactlyEntriesIn(Map<?, ?> expectedMap) {
        if (expectedMap.isEmpty()) {
            if (Preconditions.checkNotNull(this.actual).isEmpty()) {
                return IN_ORDER;
            }
            this.isEmpty();
            return ALREADY_FAILED;
        }
        boolean containsAnyOrder = this.containsEntriesInAnyOrder(expectedMap, false);
        if (containsAnyOrder) {
            return new MapInOrder(expectedMap, false, null);
        }
        return ALREADY_FAILED;
    }

    @CanIgnoreReturnValue
    public final Ordered containsAtLeastEntriesIn(Map<?, ?> expectedMap) {
        if (expectedMap.isEmpty()) {
            return IN_ORDER;
        }
        boolean containsAnyOrder = this.containsEntriesInAnyOrder(expectedMap, true);
        if (containsAnyOrder) {
            return new MapInOrder(expectedMap, true, null);
        }
        return ALREADY_FAILED;
    }

    @CanIgnoreReturnValue
    private boolean containsEntriesInAnyOrder(Map<?, ?> expectedMap, boolean allowUnexpected) {
        MapDifference<@Nullable ?, @Nullable Object, @Nullable Object> diff = MapDifference.create(Preconditions.checkNotNull(this.actual), expectedMap, allowUnexpected, Objects::equal);
        if (diff.isEmpty()) {
            return true;
        }
        this.failWithoutActual(((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(diff.describe(null))).add(Fact.simpleFact("---"))).add(Fact.fact(allowUnexpected ? "expected to contain at least" : "expected", expectedMap))).add(this.butWas())).build());
        return false;
    }

    private static String maybeAddType(@Nullable Object object, boolean includeTypes) {
        return includeTypes ? Strings.lenientFormat("%s (%s)", object, SubjectUtils.objectToTypeName(object)) : String.valueOf(object);
    }

    public final <A, E> UsingCorrespondence<A, E> comparingValuesUsing(Correspondence<? super A, ? super E> correspondence) {
        return new UsingCorrespondence(correspondence);
    }

    public final <V> UsingCorrespondence<V, V> formattingDiffsUsing(Correspondence.DiffFormatter<? super V, ? super V> formatter) {
        return this.comparingValuesUsing(Correspondence.equality().formattingDiffsUsing(formatter));
    }

    public final class UsingCorrespondence<A, E> {
        private final Correspondence<? super A, ? super E> correspondence;

        private UsingCorrespondence(Correspondence<? super A, ? super E> correspondence) {
            this.correspondence = Preconditions.checkNotNull(correspondence);
        }

        public void containsEntry(@Nullable Object expectedKey, E expectedValue) {
            if (Preconditions.checkNotNull(MapSubject.this.actual).containsKey(expectedKey)) {
                Correspondence.ExceptionStore exceptions;
                A actualValue = this.getCastSubject().get(expectedKey);
                if (this.correspondence.safeCompare(actualValue, expectedValue, exceptions = Correspondence.ExceptionStore.forMapValues())) {
                    return;
                }
                String diff = this.correspondence.safeFormatDiff(actualValue, expectedValue, exceptions);
                if (diff != null) {
                    MapSubject.this.failWithoutActual(((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(Fact.fact("for key", expectedKey))).add(Fact.fact("expected value", expectedValue))).addAll(this.correspondence.describeForMapValues())).add(Fact.fact("but got value", actualValue))).add(Fact.fact("diff", diff))).add(Fact.fact("full map", MapSubject.this.actualCustomStringRepresentationForPackageMembersToCall()))).addAll(exceptions.describeAsAdditionalInfo())).build());
                } else {
                    MapSubject.this.failWithoutActual(((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(Fact.fact("for key", expectedKey))).add(Fact.fact("expected value", expectedValue))).addAll(this.correspondence.describeForMapValues())).add(Fact.fact("but got value", actualValue))).add(Fact.fact("full map", MapSubject.this.actualCustomStringRepresentationForPackageMembersToCall()))).addAll(exceptions.describeAsAdditionalInfo())).build());
                }
            } else {
                LinkedHashSet<@Nullable ?> keys2 = new LinkedHashSet();
                Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forMapValues();
                for (Map.Entry<?, A> actualEntry : this.getCastSubject().entrySet()) {
                    if (!this.correspondence.safeCompare(actualEntry.getValue(), expectedValue, exceptions)) continue;
                    keys2.add(actualEntry.getKey());
                }
                if (!keys2.isEmpty()) {
                    MapSubject.this.failWithoutActual(((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(Fact.fact("for key", expectedKey))).add(Fact.fact("expected value", expectedValue))).addAll(this.correspondence.describeForMapValues())).add(Fact.simpleFact("but was missing"))).add(Fact.fact("other keys with matching values", keys2))).add(Fact.fact("full map", MapSubject.this.actualCustomStringRepresentationForPackageMembersToCall()))).addAll(exceptions.describeAsAdditionalInfo())).build());
                } else {
                    MapSubject.this.failWithoutActual(((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(Fact.fact("for key", expectedKey))).add(Fact.fact("expected value", expectedValue))).addAll(this.correspondence.describeForMapValues())).add(Fact.simpleFact("but was missing"))).add(Fact.fact("full map", MapSubject.this.actualCustomStringRepresentationForPackageMembersToCall()))).addAll(exceptions.describeAsAdditionalInfo())).build());
                }
            }
        }

        public void doesNotContainEntry(@Nullable Object excludedKey, E excludedValue) {
            if (Preconditions.checkNotNull(MapSubject.this.actual).containsKey(excludedKey)) {
                Correspondence.ExceptionStore exceptions;
                A actualValue = this.getCastSubject().get(excludedKey);
                if (this.correspondence.safeCompare(actualValue, excludedValue, exceptions = Correspondence.ExceptionStore.forMapValues())) {
                    MapSubject.this.failWithoutActual(((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(Fact.fact("expected not to contain", Maps.immutableEntry(excludedKey, excludedValue)))).addAll(this.correspondence.describeForMapValues())).add(Fact.fact("but contained", Maps.immutableEntry(excludedKey, actualValue)))).add(Fact.fact("full map", MapSubject.this.actualCustomStringRepresentationForPackageMembersToCall()))).addAll(exceptions.describeAsAdditionalInfo())).build());
                }
                if (exceptions.hasCompareException()) {
                    MapSubject.this.failWithoutActual(((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(exceptions.describeAsMainCause())).add(Fact.fact("expected not to contain", Maps.immutableEntry(excludedKey, excludedValue)))).addAll(this.correspondence.describeForMapValues())).add(Fact.simpleFact("found no match (but failing because of exception)"))).add(Fact.fact("full map", MapSubject.this.actualCustomStringRepresentationForPackageMembersToCall()))).build());
                }
            }
        }

        @CanIgnoreReturnValue
        public Ordered containsExactly(@Nullable Object k0, @Nullable E v0, Object ... rest) {
            Map expectedMap = MapSubject.accumulateMap("containsExactly", k0, v0, rest);
            return this.containsExactlyEntriesIn(expectedMap);
        }

        @CanIgnoreReturnValue
        public Ordered containsAtLeast(@Nullable Object k0, @Nullable E v0, Object ... rest) {
            Map expectedMap = MapSubject.accumulateMap("containsAtLeast", k0, v0, rest);
            return this.containsAtLeastEntriesIn(expectedMap);
        }

        @CanIgnoreReturnValue
        public Ordered containsExactlyEntriesIn(Map<?, ? extends E> expectedMap) {
            if (expectedMap.isEmpty()) {
                if (Preconditions.checkNotNull(MapSubject.this.actual).isEmpty()) {
                    return IN_ORDER;
                }
                MapSubject.this.isEmpty();
                return ALREADY_FAILED;
            }
            return this.internalContainsEntriesIn(expectedMap, false);
        }

        @CanIgnoreReturnValue
        public Ordered containsAtLeastEntriesIn(Map<?, ? extends E> expectedMap) {
            if (expectedMap.isEmpty()) {
                return IN_ORDER;
            }
            return this.internalContainsEntriesIn(expectedMap, true);
        }

        private <K, V extends E> Ordered internalContainsEntriesIn(Map<K, V> expectedMap, boolean allowUnexpected) {
            final Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forMapValues();
            MapDifference<@Nullable ?, A, V> diff = MapDifference.create(this.getCastSubject(), expectedMap, allowUnexpected, new ValueTester<A, E>(){

                @Override
                public boolean test(A actualValue, E expectedValue) {
                    return UsingCorrespondence.this.correspondence.safeCompare(actualValue, expectedValue, exceptions);
                }
            });
            if (diff.isEmpty()) {
                return new MapInOrder(expectedMap, allowUnexpected, this.correspondence);
            }
            MapSubject.this.failWithoutActual(((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(diff.describe(this.differ(exceptions)))).add(Fact.simpleFact("---"))).add(Fact.fact(allowUnexpected ? "expected to contain at least" : "expected", expectedMap))).addAll(this.correspondence.describeForMapValues())).add(MapSubject.this.butWas())).addAll(exceptions.describeAsAdditionalInfo())).build());
            return ALREADY_FAILED;
        }

        private <V extends E> Differ<A, V> differ(Correspondence.ExceptionStore exceptions) {
            return (actual, expected) -> this.correspondence.safeFormatDiff(actual, expected, exceptions);
        }

        private Map<?, A> getCastSubject() {
            return Preconditions.checkNotNull(MapSubject.this.actual);
        }
    }

    private class MapInOrder
    implements Ordered {
        private final Map<?, ?> expectedMap;
        private final boolean allowUnexpected;
        private final @Nullable Correspondence<?, ?> correspondence;

        MapInOrder(Map<?, ?> expectedMap, @Nullable boolean allowUnexpected, Correspondence<?, ?> correspondence) {
            this.expectedMap = expectedMap;
            this.allowUnexpected = allowUnexpected;
            this.correspondence = correspondence;
        }

        @Override
        public void inOrder() {
            Preconditions.checkNotNull(MapSubject.this.actual);
            ArrayList<?> expectedKeyOrder = Lists.newArrayList(Sets.intersection(this.expectedMap.keySet(), MapSubject.this.actual.keySet()));
            ArrayList actualKeyOrder = Lists.newArrayList(Sets.intersection(MapSubject.this.actual.keySet(), this.expectedMap.keySet()));
            if (!actualKeyOrder.equals(expectedKeyOrder)) {
                ImmutableCollection.Builder facts = ((ImmutableList.Builder)ImmutableList.builder().add(Fact.simpleFact(this.allowUnexpected ? "required entries were all found, but order was wrong" : "entries match, but order was wrong"))).add(Fact.fact(this.allowUnexpected ? "expected to contain at least" : "expected", this.expectedMap));
                if (this.correspondence != null) {
                    ((ImmutableList.Builder)facts).addAll(this.correspondence.describeForMapValues());
                }
                MapSubject.this.failWithActual(((ImmutableList.Builder)facts).build());
            }
        }
    }

    private static class ValueDifference<A, E> {
        private final A actual;
        private final E expected;

        ValueDifference(A actual, E expected) {
            this.actual = actual;
            this.expected = expected;
        }

        ImmutableList<Fact> describe(@Nullable Differ<? super A, ? super E> differ) {
            String diffString;
            boolean includeTypes = differ == null && String.valueOf(this.actual).equals(String.valueOf(this.expected));
            ImmutableCollection.Builder facts = ((ImmutableList.Builder)ImmutableList.builder().add(Fact.fact("expected value", MapSubject.maybeAddType(this.expected, includeTypes)))).add(Fact.fact("but got value", MapSubject.maybeAddType(this.actual, includeTypes)));
            if (differ != null && (diffString = differ.diff(this.actual, this.expected)) != null) {
                ((ImmutableList.Builder)facts).add(Fact.fact("diff", diffString));
            }
            return ((ImmutableList.Builder)facts).build();
        }
    }

    private static class MapDifference<K, A, E> {
        private final Map<K, E> missing;
        private final Map<K, A> unexpected;
        private final Map<K, ValueDifference<A, E>> wrongValues;
        private final Set<K> allKeys;

        static <K, A, E> MapDifference<K, A, E> create(Map<? extends K, ? extends A> actual, Map<? extends K, ? extends E> expected, boolean allowUnexpected, ValueTester<? super A, ? super E> valueTester) {
            LinkedHashMap<K, A> unexpected = new LinkedHashMap<K, A>(actual);
            LinkedHashMap<K, E> missing = new LinkedHashMap<K, E>();
            LinkedHashMap wrongValues = new LinkedHashMap();
            for (Map.Entry<K, E> expectedEntry : expected.entrySet()) {
                K expectedKey = expectedEntry.getKey();
                E expectedValue = expectedEntry.getValue();
                if (actual.containsKey(expectedKey)) {
                    Object actualValue = unexpected.remove(expectedKey);
                    if (valueTester.test(actualValue, expectedValue)) continue;
                    wrongValues.put(expectedKey, new ValueDifference(actualValue, expectedValue));
                    continue;
                }
                missing.put(expectedKey, expectedValue);
            }
            if (allowUnexpected) {
                unexpected.clear();
            }
            return new MapDifference(missing, unexpected, wrongValues, Sets.union(actual.keySet(), expected.keySet()));
        }

        private MapDifference(Map<K, E> missing, Map<K, A> unexpected, Map<K, ValueDifference<A, E>> wrongValues, Set<K> allKeys) {
            this.missing = missing;
            this.unexpected = unexpected;
            this.wrongValues = wrongValues;
            this.allKeys = allKeys;
        }

        boolean isEmpty() {
            return this.missing.isEmpty() && this.unexpected.isEmpty() && this.wrongValues.isEmpty();
        }

        ImmutableList<Fact> describe(@Nullable Differ<? super A, ? super E> differ) {
            boolean includeKeyTypes = this.includeKeyTypes();
            ImmutableList.Builder facts = ImmutableList.builder();
            if (!this.wrongValues.isEmpty()) {
                facts.add(Fact.simpleFact("keys with wrong values"));
            }
            for (Map.Entry<K, ValueDifference<A, E>> entry : this.wrongValues.entrySet()) {
                facts.add(Fact.fact("for key", MapSubject.maybeAddType(entry.getKey(), includeKeyTypes)));
                facts.addAll(entry.getValue().describe(differ));
            }
            if (!this.missing.isEmpty()) {
                facts.add(Fact.simpleFact("missing keys"));
            }
            for (Map.Entry<K, ValueDifference<A, E>> entry : this.missing.entrySet()) {
                facts.add(Fact.fact("for key", MapSubject.maybeAddType(entry.getKey(), includeKeyTypes)));
                facts.add(Fact.fact("expected value", entry.getValue()));
            }
            if (!this.unexpected.isEmpty()) {
                facts.add(Fact.simpleFact("unexpected keys"));
            }
            for (Map.Entry<K, ValueDifference<A, E>> entry : this.unexpected.entrySet()) {
                facts.add(Fact.fact("for key", MapSubject.maybeAddType(entry.getKey(), includeKeyTypes)));
                facts.add(Fact.fact("unexpected value", entry.getValue()));
            }
            return facts.build();
        }

        private boolean includeKeyTypes() {
            HashSet<K> keys2 = Sets.newHashSet();
            keys2.addAll(this.missing.keySet());
            keys2.addAll(this.unexpected.keySet());
            keys2.addAll(this.wrongValues.keySet());
            return SubjectUtils.hasMatchingToStringPair(keys2, this.allKeys);
        }
    }

    private static interface Differ<A, E> {
        public @Nullable String diff(A var1, E var2);
    }

    private static interface ValueTester<A, E> {
        public boolean test(A var1, E var2);
    }
}

