/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.primitives.Doubles;

final class MathUtil {
    private MathUtil() {
    }

    static boolean equalWithinTolerance(long left, long right, long tolerance) {
        try {
            long absDiff = Math.abs(Math.subtractExact(left, right));
            return 0L <= absDiff && absDiff <= Math.abs(tolerance);
        }
        catch (ArithmeticException e) {
            return false;
        }
    }

    static boolean equalWithinTolerance(int left, int right, int tolerance) {
        try {
            int absDiff = Math.abs(Math.subtractExact(left, right));
            return 0 <= absDiff && absDiff <= Math.abs(tolerance);
        }
        catch (ArithmeticException e) {
            return false;
        }
    }

    public static boolean equalWithinTolerance(double left, double right, double tolerance) {
        return Math.abs(left - right) <= Math.abs(tolerance);
    }

    public static boolean equalWithinTolerance(float left, float right, float tolerance) {
        return MathUtil.equalWithinTolerance((double)left, (double)right, (double)tolerance);
    }

    public static boolean notEqualWithinTolerance(double left, double right, double tolerance) {
        if (Doubles.isFinite(left) && Doubles.isFinite(right)) {
            return Math.abs(left - right) > Math.abs(tolerance);
        }
        return false;
    }

    public static boolean notEqualWithinTolerance(float left, float right, float tolerance) {
        return MathUtil.notEqualWithinTolerance((double)left, (double)right, (double)tolerance);
    }
}

