/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.rules.RuleMemberValidator;
import org.junit.internal.runners.statements.ExpectException;
import org.junit.internal.runners.statements.Fail;
import org.junit.internal.runners.statements.FailOnTimeout;
import org.junit.internal.runners.statements.InvokeMethod;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.RuleContainer;
import org.junit.runners.model.FrameworkMember;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.MemberValueConsumer;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.junit.validator.PublicClassValidator;
import org.junit.validator.TestClassValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockJUnit4ClassRunner
extends ParentRunner<FrameworkMethod> {
    private static TestClassValidator PUBLIC_CLASS_VALIDATOR = new PublicClassValidator();
    private final ConcurrentMap<FrameworkMethod, Description> methodDescriptions = new ConcurrentHashMap<FrameworkMethod, Description>();
    private static final ThreadLocal<RuleContainer> CURRENT_RULE_CONTAINER = new ThreadLocal();

    public BlockJUnit4ClassRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
    }

    protected BlockJUnit4ClassRunner(TestClass testClass) throws InitializationError {
        super(testClass);
    }

    @Override
    protected void runChild(final FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        if (this.isIgnored(method)) {
            notifier.fireTestIgnored(description);
        } else {
            Statement statement = new Statement(){

                public void evaluate() throws Throwable {
                    BlockJUnit4ClassRunner.this.methodBlock(method).evaluate();
                }
            };
            this.runLeaf(statement, description, notifier);
        }
    }

    @Override
    protected boolean isIgnored(FrameworkMethod child) {
        return child.getAnnotation(Ignore.class) != null;
    }

    @Override
    protected Description describeChild(FrameworkMethod method) {
        Description description = (Description)this.methodDescriptions.get(method);
        if (description == null) {
            description = Description.createTestDescription(this.getTestClass().getJavaClass(), this.testName(method), method.getAnnotations());
            this.methodDescriptions.putIfAbsent(method, description);
        }
        return description;
    }

    @Override
    protected List<FrameworkMethod> getChildren() {
        return this.computeTestMethods();
    }

    protected List<FrameworkMethod> computeTestMethods() {
        return this.getTestClass().getAnnotatedMethods(Test.class);
    }

    @Override
    protected void collectInitializationErrors(List<Throwable> errors) {
        super.collectInitializationErrors(errors);
        this.validatePublicConstructor(errors);
        this.validateNoNonStaticInnerClass(errors);
        this.validateConstructor(errors);
        this.validateInstanceMethods(errors);
        this.validateFields(errors);
        this.validateMethods(errors);
    }

    private void validatePublicConstructor(List<Throwable> errors) {
        if (this.getTestClass().getJavaClass() != null) {
            errors.addAll(PUBLIC_CLASS_VALIDATOR.validateTestClass(this.getTestClass()));
        }
    }

    protected void validateNoNonStaticInnerClass(List<Throwable> errors) {
        if (this.getTestClass().isANonStaticInnerClass()) {
            String gripe = "The inner class " + this.getTestClass().getName() + " is not static.";
            errors.add(new Exception(gripe));
        }
    }

    protected void validateConstructor(List<Throwable> errors) {
        this.validateOnlyOneConstructor(errors);
        this.validateZeroArgConstructor(errors);
    }

    protected void validateOnlyOneConstructor(List<Throwable> errors) {
        if (!this.hasOneConstructor()) {
            String gripe = "Test class should have exactly one public constructor";
            errors.add(new Exception(gripe));
        }
    }

    protected void validateZeroArgConstructor(List<Throwable> errors) {
        if (!this.getTestClass().isANonStaticInnerClass() && this.hasOneConstructor() && this.getTestClass().getOnlyConstructor().getParameterTypes().length != 0) {
            String gripe = "Test class should have exactly one public zero-argument constructor";
            errors.add(new Exception(gripe));
        }
    }

    private boolean hasOneConstructor() {
        return this.getTestClass().getJavaClass().getConstructors().length == 1;
    }

    @Deprecated
    protected void validateInstanceMethods(List<Throwable> errors) {
        this.validatePublicVoidNoArgMethods(After.class, false, errors);
        this.validatePublicVoidNoArgMethods(Before.class, false, errors);
        this.validateTestMethods(errors);
        if (this.computeTestMethods().isEmpty()) {
            errors.add(new Exception("No runnable methods"));
        }
    }

    protected void validateFields(List<Throwable> errors) {
        RuleMemberValidator.RULE_VALIDATOR.validate(this.getTestClass(), errors);
    }

    private void validateMethods(List<Throwable> errors) {
        RuleMemberValidator.RULE_METHOD_VALIDATOR.validate(this.getTestClass(), errors);
    }

    protected void validateTestMethods(List<Throwable> errors) {
        this.validatePublicVoidNoArgMethods(Test.class, false, errors);
    }

    protected Object createTest() throws Exception {
        return this.getTestClass().getOnlyConstructor().newInstance(new Object[0]);
    }

    protected Object createTest(FrameworkMethod method) throws Exception {
        return this.createTest();
    }

    protected String testName(FrameworkMethod method) {
        return method.getName();
    }

    protected Statement methodBlock(final FrameworkMethod method) {
        Object test;
        try {
            test = new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return BlockJUnit4ClassRunner.this.createTest(method);
                }
            }.run();
        }
        catch (Throwable e) {
            return new Fail(e);
        }
        Statement statement = this.methodInvoker(method, test);
        statement = this.possiblyExpectingExceptions(method, test, statement);
        statement = this.withPotentialTimeout(method, test, statement);
        statement = this.withBefores(method, test, statement);
        statement = this.withAfters(method, test, statement);
        statement = this.withRules(method, test, statement);
        statement = this.withInterruptIsolation(statement);
        return statement;
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        return new InvokeMethod(method, test);
    }

    protected Statement possiblyExpectingExceptions(FrameworkMethod method, Object test, Statement next) {
        Test annotation = method.getAnnotation(Test.class);
        Class<? extends Throwable> expectedExceptionClass = this.getExpectedException(annotation);
        return expectedExceptionClass != null ? new ExpectException(next, expectedExceptionClass) : next;
    }

    @Deprecated
    protected Statement withPotentialTimeout(FrameworkMethod method, Object test, Statement next) {
        long timeout = this.getTimeout(method.getAnnotation(Test.class));
        if (timeout <= 0L) {
            return next;
        }
        return FailOnTimeout.builder().withTimeout(timeout, TimeUnit.MILLISECONDS).build(next);
    }

    protected Statement withBefores(FrameworkMethod method, Object target, Statement statement) {
        List<FrameworkMethod> befores = this.getTestClass().getAnnotatedMethods(Before.class);
        return befores.isEmpty() ? statement : new RunBefores(statement, befores, target);
    }

    protected Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
        List<FrameworkMethod> afters = this.getTestClass().getAnnotatedMethods(After.class);
        return afters.isEmpty() ? statement : new RunAfters(statement, afters, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement withRules(FrameworkMethod method, Object target, Statement statement) {
        RuleContainer ruleContainer = new RuleContainer();
        CURRENT_RULE_CONTAINER.set(ruleContainer);
        try {
            List<TestRule> testRules = this.getTestRules(target);
            for (MethodRule each : this.rules(target)) {
                if (each instanceof TestRule && testRules.contains(each)) continue;
                ruleContainer.add(each);
            }
            for (TestRule rule : testRules) {
                ruleContainer.add(rule);
            }
        }
        finally {
            CURRENT_RULE_CONTAINER.remove();
        }
        return ruleContainer.apply(method, this.describeChild(method), target, statement);
    }

    protected List<MethodRule> rules(Object target) {
        RuleCollector collector2 = new RuleCollector();
        this.getTestClass().collectAnnotatedMethodValues(target, Rule.class, MethodRule.class, collector2);
        this.getTestClass().collectAnnotatedFieldValues(target, Rule.class, MethodRule.class, collector2);
        return collector2.result;
    }

    protected List<TestRule> getTestRules(Object target) {
        RuleCollector collector2 = new RuleCollector();
        this.getTestClass().collectAnnotatedMethodValues(target, Rule.class, TestRule.class, collector2);
        this.getTestClass().collectAnnotatedFieldValues(target, Rule.class, TestRule.class, collector2);
        return collector2.result;
    }

    private Class<? extends Throwable> getExpectedException(Test annotation) {
        if (annotation == null || annotation.expected() == Test.None.class) {
            return null;
        }
        return annotation.expected();
    }

    private long getTimeout(Test annotation) {
        if (annotation == null) {
            return 0L;
        }
        return annotation.timeout();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RuleCollector<T>
    implements MemberValueConsumer<T> {
        final List<T> result = new ArrayList<T>();

        private RuleCollector() {
        }

        @Override
        public void accept(FrameworkMember<?> member, T value) {
            RuleContainer container;
            Rule rule = member.getAnnotation(Rule.class);
            if (rule != null && (container = (RuleContainer)CURRENT_RULE_CONTAINER.get()) != null) {
                container.setOrder(value, rule.order());
            }
            this.result.add(value);
        }
    }
}

