/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.context;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.context.Context;
import io.helidon.common.context.ContextAwareExecutorService;
import io.helidon.common.context.Contexts;
import io.helidon.common.context.spi.DataPropagationProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

class ContextAwareExecutorImpl
implements ContextAwareExecutorService {
    private static final List<DataPropagationProvider> PROVIDERS = HelidonServiceLoader.builder(ServiceLoader.load(DataPropagationProvider.class)).build().asList();
    private final ExecutorService delegate;

    ContextAwareExecutorImpl(ExecutorService toWrap) {
        this.delegate = toWrap;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(this.wrap(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(this.wrap(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate.submit(this.wrap(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(this.wrap(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(this.wrap(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(this.wrap(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(this.wrap(tasks), timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(this.wrap(command));
    }

    @Override
    public ExecutorService unwrap() {
        return this.delegate;
    }

    protected <T> Collection<? extends Callable<T>> wrap(Collection<? extends Callable<T>> tasks) {
        return tasks.stream().map(this::wrap).collect(Collectors.toList());
    }

    protected <T> Callable<T> wrap(Callable<T> task) {
        Optional<Context> context = Contexts.context();
        if (context.isPresent()) {
            HashMap properties = new HashMap();
            PROVIDERS.forEach(provider -> properties.put(provider.getClass(), provider.data()));
            return () -> {
                try {
                    PROVIDERS.forEach(provider -> provider.propagateData(properties.get(provider.getClass())));
                    Object t = Contexts.runInContext((Context)context.get(), task);
                    return t;
                }
                finally {
                    PROVIDERS.forEach(provider -> provider.clearData(properties.get(provider.getClass())));
                }
            };
        }
        return task;
    }

    protected Runnable wrap(Runnable command) {
        Optional<Context> context = Contexts.context();
        if (context.isPresent()) {
            HashMap properties = new HashMap();
            PROVIDERS.forEach(provider -> properties.put(provider.getClass(), provider.data()));
            return () -> {
                try {
                    PROVIDERS.forEach(provider -> provider.propagateData(properties.get(provider.getClass())));
                    Contexts.runInContext((Context)context.get(), command);
                }
                finally {
                    PROVIDERS.forEach(provider -> provider.clearData(properties.get(provider.getClass())));
                }
            };
        }
        return command;
    }
}

