/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.crypto;

import io.helidon.common.Base64Value;
import io.helidon.common.crypto.Digest;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Objects;

public class HashDigest
implements Digest {
    @Deprecated
    public static final String ALGORITHM_MD2 = "MD2";
    @Deprecated
    public static final String ALGORITHM_MD5 = "MD5";
    @Deprecated
    public static final String ALGORITHM_SHA_1 = "SHA-1";
    public static final String ALGORITHM_SHA_224 = "SHA-224";
    public static final String ALGORITHM_SHA_256 = "SHA-256";
    public static final String ALGORITHM_SHA_384 = "SHA-384";
    public static final String ALGORITHM_SHA_512_224 = "SHA-512/224";
    public static final String ALGORITHM_SHA_512_256 = "SHA-512/256";
    public static final String ALGORITHM_SHA3_224 = "SHA3-224";
    public static final String ALGORITHM_SHA3_256 = "SHA3-256";
    public static final String ALGORITHM_SHA3_384 = "SHA3-384";
    public static final String ALGORITHM_SHA3_512 = "SHA3-512";
    private final String algorithm;
    private final String provider;

    private HashDigest(Builder builder) {
        this.algorithm = builder.algorithm;
        this.provider = builder.provider;
    }

    public static HashDigest create(String algorithm) {
        return HashDigest.builder().algorithm(algorithm).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Base64Value digest(Base64Value value) {
        try {
            MessageDigest digest = this.provider == null ? MessageDigest.getInstance(this.algorithm) : MessageDigest.getInstance(this.algorithm, this.provider);
            return Base64Value.create((byte[])digest.digest(value.toBytes()));
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new IllegalStateException("Could not create digest", e);
        }
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, HashDigest> {
        private String algorithm = "SHA-256";
        private String provider = null;

        private Builder() {
        }

        public Builder algorithm(String algorithm) {
            this.algorithm = Objects.requireNonNull(algorithm, "Algorithm cannot be null");
            return this;
        }

        public Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public HashDigest build() {
            return new HashDigest(this);
        }
    }
}

