/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.mapper;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.MapperException;
import io.helidon.common.mapper.MapperManager;
import io.helidon.common.mapper.OptionalValue;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

class ValueEmpty<T>
implements OptionalValue<T> {
    private final MapperManager mapperManager;
    private final GenericType<T> type;
    private final String name;
    private final String[] qualifiers;

    ValueEmpty(MapperManager mapperManager, GenericType<T> type, String name, String[] qualifiers) {
        this.mapperManager = mapperManager;
        this.type = type;
        this.name = name;
        this.qualifiers = qualifiers;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Optional<T> asOptional() throws MapperException {
        return Optional.empty();
    }

    @Override
    public <N> OptionalValue<N> as(Function<? super T, ? extends N> mapper) {
        return this;
    }

    @Override
    public <N> OptionalValue<N> as(Class<N> type) throws MapperException {
        GenericType wantedType = GenericType.create(type);
        if (this.mapperManager.mapper(this.type, wantedType, this.qualifiers).isPresent()) {
            return new ValueEmpty<T>(this.mapperManager, wantedType, this.name, this.qualifiers);
        }
        throw new MapperException(this.type, wantedType, "Cannot find mapper for " + this.name());
    }

    @Override
    public <N> OptionalValue<N> as(GenericType<N> type) throws MapperException {
        if (this.mapperManager.mapper(this.type, type, this.qualifiers).isPresent()) {
            return new ValueEmpty<N>(this.mapperManager, type, this.name, this.qualifiers);
        }
        throw new MapperException(this.type, type, "Cannot find mapper for " + this.name());
    }

    @Override
    public T get() {
        throw new NoSuchElementException("No value present for " + this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OptionalValue)) {
            return false;
        }
        OptionalValue other = (OptionalValue)o;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.asOptional(), other.asOptional());
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

